/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.loaders.fabric;

import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1936;
import net.minecraft.class_2168;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.init.BlockInit;
import net.rasanovum.viaromana.init.EffectInit;
import net.rasanovum.viaromana.init.ItemInit;
import net.rasanovum.viaromana.init.StatInit;
import net.rasanovum.viaromana.network.PacketRegistration;

public class FabricMain
implements ModInitializer {
    public void onInitialize() {
        ViaRomana.initialize();
        new PacketRegistration().initCommon();
        EffectInit.load();
        BlockInit.load();
        ItemInit.load();
        StatInit.register();
        this.registerServerLifecycleEvents();
    }

    private void registerServerLifecycleEvents() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> ViaRomana.onJoin(handler.field_14140));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> ViaRomana.onLeave(handler.field_14140));
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (class_3218 level : server.method_3738()) {
                ViaRomana.onServerTick(level);
            }
        });
        ServerLifecycleEvents.SERVER_STARTING.register(server -> ViaRomana.onServerStart(server));
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> ViaRomana.onServerStop());
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, resourceManager, success) -> ViaRomana.onDataPackReload(server));
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, level) -> ViaRomana.onDimensionChange(level, player));
        PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, blockentity) -> {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                return ViaRomana.onBlockBreak((class_1936)world, pos, serverPlayer);
            }
            return true;
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> ViaRomana.registerCommands((CommandDispatcher<class_2168>)dispatcher));
    }
}

