/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.map;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3620;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.map.MapPixelAssembler;
import net.rasanovum.viaromana.storage.level.LevelDataManager;
import net.rasanovum.viaromana.util.VersionUtils;
import org.jetbrains.annotations.Nullable;

public class ChunkPixelRenderer {
    private static final Map<class_2960, Integer> biomeColorCache = new HashMap<class_2960, Integer>();
    private static Map<String, Integer> parsedBiomeColors = null;
    private static final class_3620 WATER_MAP_COLOR = class_3620.field_16019;
    private static class_6862<class_1959> badlandsTag;
    private static class_6862<class_1959> beachTag;
    private static class_6862<class_1959> oceanTag;
    private static class_6862<class_1959> deepOceanTag;
    private static class_6862<class_1959> endTag;
    private static class_6862<class_1959> forestTag;
    private static class_6862<class_1959> hillTag;
    private static class_6862<class_1959> jungleTag;
    private static class_6862<class_1959> mountainTag;
    private static class_6862<class_1959> netherTag;
    private static class_6862<class_1959> riverTag;
    private static class_6862<class_1959> savannaTag;
    private static class_6862<class_1959> taigaTag;
    private static class_6862<class_1959> desertTag;
    private static class_6862<class_1959> swampTag;
    private static class_6862<class_1959> plainsTag;

    public static void init() {
        biomeColorCache.clear();
        parsedBiomeColors = new HashMap<String, Integer>();
        for (String biomePair : CommonConfig.biome_color_pairs) {
            if (biomePair.trim().isEmpty()) continue;
            try {
                String[] parts = biomePair.split("=", 2);
                if (parts.length != 2) continue;
                String biome = parts[0].trim();
                int color = Integer.parseInt(parts[1].trim());
                parsedBiomeColors.put(biome, color);
            }
            catch (Exception e) {
                ViaRomana.LOGGER.warn("Skipping invalid biome color pair '{}': {}", (Object)biomePair, (Object)e.getMessage());
            }
        }
        ViaRomana.LOGGER.info("Loaded {} biome-color pairs from config.", (Object)parsedBiomeColors.size());
        badlandsTag = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)VersionUtils.getLocation("minecraft:is_badlands"));
        beachTag = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)VersionUtils.getLocation("minecraft:is_beach"));
        oceanTag = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)VersionUtils.getLocation("minecraft:is_ocean"));
        deepOceanTag = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)VersionUtils.getLocation("minecraft:is_deep_ocean"));
        endTag = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)VersionUtils.getLocation("minecraft:is_end"));
        forestTag = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)VersionUtils.getLocation("minecraft:is_forest"));
        hillTag = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)VersionUtils.getLocation("minecraft:is_hill"));
        jungleTag = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)VersionUtils.getLocation("minecraft:is_jungle"));
        mountainTag = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)VersionUtils.getLocation("minecraft:is_mountain"));
        netherTag = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)VersionUtils.getLocation("minecraft:is_nether"));
        riverTag = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)VersionUtils.getLocation("minecraft:is_river"));
        savannaTag = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)VersionUtils.getLocation("minecraft:is_savanna"));
        taigaTag = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)VersionUtils.getLocation("minecraft:is_taiga"));
        desertTag = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)VersionUtils.getLocation("minecraft:is_desert"));
        swampTag = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)VersionUtils.getLocation("minecraft:allows_surface_slime_spawns"));
        plainsTag = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)VersionUtils.getLocation("minecraft:has_structure/village_plains"));
    }

    public static byte[] renderChunkPixels(class_3218 level, class_1923 pos) {
        long startTime = System.nanoTime();
        class_2818 chunk = level.method_8497(pos.field_9181, pos.field_9180);
        int minY = chunk.method_31607();
        byte[] pixels = new byte[256];
        int chunkMinX = pos.method_8326();
        int chunkMinZ = pos.method_8328();
        int[] surfaceHeights = new int[256];
        int[] floorHeights = new int[256];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int idx = x + z * 16;
                surfaceHeights[idx] = chunk.method_12005(class_2902.class_2903.field_13197, x, z);
                floorHeights[idx] = chunk.method_12005(class_2902.class_2903.field_13200, x, z);
            }
        }
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                class_3620.class_6594 brightness;
                class_3620 mapColor;
                int idx = x + z * 16;
                int surfaceY = surfaceHeights[idx];
                if (surfaceY <= minY) {
                    pixels[idx] = 0;
                    continue;
                }
                int waterDepth = surfaceY - floorHeights[idx];
                if (waterDepth > 0) {
                    mapColor = WATER_MAP_COLOR;
                    brightness = ChunkPixelRenderer.calculateWaterBrightness(idx, waterDepth);
                } else {
                    mutablePos.method_10103(chunkMinX + x, surfaceY, chunkMinZ + z);
                    class_2680 state = chunk.method_8320((class_2338)mutablePos);
                    mapColor = state.method_26205((class_1922)level, (class_2338)mutablePos);
                    while (mapColor == class_3620.field_16008 && mutablePos.method_10264() > minY) {
                        mutablePos.method_10100(0, -1, 0);
                        state = chunk.method_8320((class_2338)mutablePos);
                        mapColor = state.method_26205((class_1922)level, (class_2338)mutablePos);
                    }
                    brightness = ChunkPixelRenderer.calculateTerrainBrightness(surfaceHeights, idx);
                }
                pixels[idx] = mapColor.method_38481(brightness);
            }
        }
        long totalTime = System.nanoTime() - startTime;
        return pixels;
    }

    public static byte[] scalePixels(byte[] pixels, int scaleFactor) {
        if (scaleFactor == 1) {
            return pixels;
        }
        int newSize = 16 / scaleFactor;
        byte[] scaled = new byte[newSize * newSize];
        for (int dx = 0; dx < newSize; ++dx) {
            for (int dz = 0; dz < newSize; ++dz) {
                int srcX = dx * scaleFactor;
                int srcZ = dz * scaleFactor;
                int srcIdx = srcX + srcZ * 16;
                scaled[dx + dz * newSize] = pixels[srcIdx];
            }
        }
        return scaled;
    }

    private static class_3620.class_6594 calculateWaterBrightness(int idx, int waterDepth) {
        double shade = Math.min((double)waterDepth / 8.0, 1.0) + (double)((idx >> 4) + (idx & 0xF) & 1) * 0.15;
        if ((shade = Math.max(0.1, Math.min(0.9, shade))) < 0.3) {
            return class_3620.class_6594.field_34761;
        }
        if (shade > 0.7) {
            return class_3620.class_6594.field_34759;
        }
        return class_3620.class_6594.field_34760;
    }

    private static class_3620.class_6594 calculateTerrainBrightness(int[] heights, int idx) {
        int z_row;
        int currentHeight = heights[idx];
        int x_col = idx & 0xF;
        int westHeight = x_col > 0 ? heights[idx - 1] : currentHeight;
        double shade = (double)(currentHeight - westHeight) * 4.0 / 2.0 + ((double)(x_col + (z_row = idx >> 4) & 1) - 0.5) * 0.4;
        if (shade > 0.6) {
            return class_3620.class_6594.field_34761;
        }
        if (shade < -0.6) {
            return class_3620.class_6594.field_34759;
        }
        return class_3620.class_6594.field_34760;
    }

    public static MapPixelAssembler.BiomePixelResult getOrRenderBiomePixels(class_3218 level, class_1923 biomeChunk, class_1966 biomeSource, class_6544.class_6552 climateSampler, int maxBuildHeight) {
        byte @Nullable [] cachedCorners = LevelDataManager.getCornerBytes(level, biomeChunk);
        int[] cornerPackedIds = new int[4];
        int cacheIncrement = 0;
        int renderIncrement = 0;
        if (cachedCorners != null) {
            for (int i = 0; i < 4; ++i) {
                cornerPackedIds[i] = cachedCorners[i] & 0xFF;
            }
            cacheIncrement = 1;
        } else {
            int[][] corners = new int[][]{{0, 0}, {3, 0}, {0, 3}, {3, 3}};
            class_6880[] cornerBiomes = new class_6880[4];
            for (int c = 0; c < 4; ++c) {
                int blockX = biomeChunk.method_8326() + corners[c][0] * 4;
                int blockZ = biomeChunk.method_8328() + corners[c][1] * 4;
                int quartX = blockX >> 2;
                int quartY = maxBuildHeight >> 2;
                int quartZ = blockZ >> 2;
                cornerBiomes[c] = biomeSource.method_38109(quartX, quartY, quartZ, climateSampler);
            }
            byte[] cornerBytes = new byte[4];
            for (int c = 0; c < 4; ++c) {
                int colorIndex = ChunkPixelRenderer.getColorIndex(level, (class_6880<class_1959>)cornerBiomes[c]);
                int brightness = colorIndex == 12 ? 0 : 1;
                cornerPackedIds[c] = colorIndex * 4 + brightness;
                cornerBytes[c] = (byte)cornerPackedIds[c];
            }
            LevelDataManager.setCornerBytes(level, biomeChunk, cornerBytes);
            renderIncrement = 1;
        }
        byte[] pixels = new byte[256];
        for (int i = 0; i < 256; ++i) {
            int px = i % 16;
            int pz = i / 16;
            int cornerIndex = pz >> 3 << 1 | px >> 3;
            pixels[i] = (byte)cornerPackedIds[cornerIndex];
        }
        return new MapPixelAssembler.BiomePixelResult(pixels, cacheIncrement, renderIncrement);
    }

    private static int getColorIndex(class_3218 level, class_6880<class_1959> holder) {
        class_1959 biome = (class_1959)holder.comp_349();
        class_2960 biomeId = level.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome);
        assert (biomeId != null);
        if (biomeColorCache.containsKey(biomeId)) {
            return biomeColorCache.get(biomeId);
        }
        int colorIndex = 0;
        if (parsedBiomeColors != null && parsedBiomeColors.containsKey(biomeId.toString())) {
            colorIndex = parsedBiomeColors.get(biomeId.toString());
            biomeColorCache.put(biomeId, colorIndex);
            return colorIndex;
        }
        String biomePath = biomeId.method_12832().toLowerCase();
        if (biomePath.contains("snow") || biomePath.contains("ice") || biomePath.contains("tundra")) {
            colorIndex = 8;
        } else if (holder.method_40220(forestTag) || holder.method_40220(taigaTag) || holder.method_40220(jungleTag) || holder.method_40220(swampTag) || biomePath.contains("forest")) {
            colorIndex = 7;
        } else if (holder.method_40220(deepOceanTag) || holder.method_40220(oceanTag) || holder.method_40220(riverTag) || biomePath.contains("ocean")) {
            colorIndex = 12;
        } else if (holder.method_40220(mountainTag) || holder.method_40220(hillTag) || biomePath.contains("mountain") || biomePath.contains("hill") || biomePath.contains("stony_shore")) {
            colorIndex = 11;
        } else if (holder.method_40220(plainsTag) || biomePath.contains("plains") || biomePath.contains("meadow")) {
            colorIndex = 1;
        } else if (holder.method_40220(beachTag) || holder.method_40220(endTag) || holder.method_40220(desertTag) || biomePath.contains("desert")) {
            colorIndex = 2;
        } else if (holder.method_40220(savannaTag) || biomePath.contains("savanna")) {
            colorIndex = 27;
        } else if (holder.method_40220(badlandsTag) || biomePath.contains("badlands")) {
            colorIndex = 15;
        } else if (holder.method_40220(netherTag)) {
            colorIndex = 35;
        } else if (biomePath.contains("mushroom_fields")) {
            colorIndex = 24;
        } else {
            ViaRomana.LOGGER.warn("Biome {} did not match any color index rules, defaulting to 0", (Object)biomeId);
        }
        biomeColorCache.put(biomeId, colorIndex);
        return colorIndex;
    }
}

