/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import dev.corgitaco.dataanchor.network.Packet;
import dev.corgitaco.dataanchor.network.broadcast.PacketBroadcaster;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.network.AbstractPacket;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;
import net.rasanovum.viaromana.network.packets.TeleportRequestC2S;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.teleport.ServerTeleportHandler;

public record DestinationRequestC2S(class_2338 sourceSignPos) implements AbstractPacket
{
    public DestinationRequestC2S(class_2540 buf) {
        this(buf.method_10811());
    }

    public void write(class_2540 buf) {
        buf.method_10807(this.sourceSignPos);
    }

    public void handle(class_1937 level, class_1657 player) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                PathGraph graph = PathGraph.getInstance(serverLevel);
                Optional<Node> sourceNodeOpt = graph.getNodeBySignPos(this.sourceSignPos);
                if (sourceNodeOpt.isEmpty()) {
                    ViaRomana.LOGGER.warn("Received destination request for unknown sign at {}", (Object)this.sourceSignPos);
                    return;
                }
                Node sourceNode = sourceNodeOpt.get();
                List<Node> destinations = graph.getCachedTeleportDestinationsFor(serverPlayer.method_5667(), sourceNode);
                PathGraph.NetworkCache cache = graph.getNetworkCache(sourceNode);
                List<DestinationResponseS2C.DestinationInfo> destInfos = graph.getNodesAsDestinationInfo(destinations, sourceNode.getBlockPos());
                List<DestinationResponseS2C.NodeNetworkInfo> networkInfos = graph.getNodesAsInfo(cache);
                DestinationResponseS2C response = new DestinationResponseS2C(destInfos, this.sourceSignPos, sourceNode.getBlockPos(), networkInfos, cache.id());
                if (!CommonConfig.direct_warp || destInfos.size() > 1) {
                    PacketBroadcaster.S2C.sendToPlayer((Packet)response, serverPlayer);
                } else if (destInfos.size() == 1) {
                    TeleportRequestC2S packet = new TeleportRequestC2S(this.sourceSignPos, destInfos.get((int)0).position);
                    ServerTeleportHandler.handleTeleportRequest(packet, (class_3222)player);
                }
            }
        }
    }
}

