/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.map.MapBaker;
import net.rasanovum.viaromana.map.ServerMapCache;
import net.rasanovum.viaromana.network.AbstractPacket;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;

public record PreProcessChunksC2S(List<Node.NodeData> tempNodes) implements AbstractPacket
{
    public PreProcessChunksC2S(List<Node.NodeData> tempNodes) {
        this.tempNodes = tempNodes != null ? List.copyOf(tempNodes) : List.of();
    }

    public PreProcessChunksC2S(class_2540 buf) {
        this(PreProcessChunksC2S.readNodes(buf));
    }

    private static List<Node.NodeData> readNodes(class_2540 buf) {
        int nodeCount = buf.readInt();
        ArrayList<Node.NodeData> nodes = new ArrayList<Node.NodeData>(nodeCount);
        for (int i = 0; i < nodeCount; ++i) {
            class_2338 pos = buf.method_10811();
            float quality = buf.readFloat();
            float clearance = buf.readFloat();
            nodes.add(new Node.NodeData(pos, quality, clearance));
        }
        return nodes;
    }

    public void write(class_2540 buf) {
        buf.writeInt(this.tempNodes.size());
        for (Node.NodeData nodeData : this.tempNodes) {
            buf.method_10807(nodeData.pos());
            buf.writeFloat(nodeData.quality());
            buf.writeFloat(nodeData.clearance());
        }
    }

    public void handle(class_1937 level, class_1657 player) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (player instanceof class_3222) {
                PathGraph graph;
                class_3222 serverPlayer = (class_3222)player;
                if (this.tempNodes.isEmpty() || this.tempNodes.size() < 2) {
                    return;
                }
                UUID playerUUID = serverPlayer.method_5667();
                UUID pseudoNetworkId = ServerMapCache.getPseudoNetworkId(playerUUID);
                if (CommonConfig.logging_enum.ordinal() > 1) {
                    ViaRomana.LOGGER.info("Creating/updating pseudonetwork {} for player {} with {} temp nodes", (Object)pseudoNetworkId, (Object)serverPlayer.method_5477().getString(), (Object)this.tempNodes.size());
                }
                if ((graph = PathGraph.getInstance(serverLevel)) == null) {
                    ViaRomana.LOGGER.warn("PathGraph is null, cannot create pseudonetwork");
                    return;
                }
                graph.createOrUpdatePseudoNetwork(pseudoNetworkId, this.tempNodes);
                ServerMapCache.markAsPseudoNetwork(pseudoNetworkId);
                ExecutorService executor = ServerMapCache.getMapBakingExecutor();
                if (executor != null && !executor.isShutdown()) {
                    ((CompletableFuture)MapBaker.bakeAsync(pseudoNetworkId, serverLevel, executor).thenAccept(mapInfo -> {
                        if (mapInfo != null && CommonConfig.logging_enum.ordinal() > 1) {
                            ViaRomana.LOGGER.info("Completed async chunk pre-processing for pseudonetwork {}: {}x{} pixels", (Object)pseudoNetworkId, (Object)mapInfo.pixelWidth(), (Object)mapInfo.pixelHeight());
                        }
                    })).exceptionally(ex -> {
                        ViaRomana.LOGGER.error("Error during async chunk pre-processing for pseudonetwork {}", (Object)pseudoNetworkId, ex);
                        return null;
                    });
                } else {
                    ViaRomana.LOGGER.warn("Map baking executor not available, skipping chunk pre-processing");
                }
            }
        }
    }
}

