/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.network.AbstractPacket;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.path.PathDataManager;
import net.rasanovum.viaromana.util.PathSyncUtils;

public record RoutedActionC2S(Operation op) implements AbstractPacket
{
    public RoutedActionC2S(class_2540 buf) {
        this(Operation.values()[buf.method_10816()]);
    }

    public void write(class_2540 buf) {
        buf.method_10804(this.op.ordinal());
    }

    public void handle(class_1937 level, class_1657 player) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                PathGraph graph = PathGraph.getInstance(serverLevel);
                Optional<Node> nearestOpt = graph.getNearestNode(serverPlayer.method_24515(), CommonConfig.node_utility_distance, node -> true);
                if (nearestOpt.isEmpty()) {
                    ViaRomana.LOGGER.warn("No nearby node found for action {} by player {}", (Object)this.op, (Object)serverPlayer.method_5477().getString());
                    return;
                }
                Node nearestNode = nearestOpt.get();
                switch (this.op.ordinal()) {
                    case 0: {
                        graph.removeNode(nearestNode);
                        break;
                    }
                    case 1: {
                        graph.removeBranch(nearestNode);
                    }
                }
                PathDataManager.markDirty(serverLevel);
                PathSyncUtils.syncPathGraphToAllPlayers(serverLevel);
            }
        }
    }

    public static enum Operation {
        SEVER_NEAREST_NODE,
        REMOVE_BRANCH;

    }
}

