/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.speed;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_161;
import net.minecraft.class_167;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_5134;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.init.StatInit;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;

public class SpeedHandler {
    public static final UUID PROXIMITY_SPEED_ID = UUID.nameUUIDFromBytes("viaromana:node_proximity_speed".getBytes(StandardCharsets.UTF_8));
    public static final String PROXIMITY_SPEED_NAME = "node_proximity_speed";
    private static final double DISTANCE_THRESHOLD = 500000.0;
    private static final Map<UUID, class_2338> lastPathWalkPositions = new HashMap<UUID, class_2338>();

    public static void resetState(class_3222 player) {
        lastPathWalkPositions.remove(player.method_5667());
    }

    public static void onPlayerTick(class_3222 player) {
        boolean hasModifier;
        if (player.method_37908().field_9236) {
            return;
        }
        class_1324 speedAttribute = player.method_5996(class_5134.field_23719);
        if (speedAttribute == null) {
            return;
        }
        boolean nearNode = false;
        PathGraph graph = PathGraph.getInstance((class_3218)player.method_37908());
        if (graph != null) {
            Optional<Node> nearestNode = graph.getNearestNode(player.method_24515(), CommonConfig.node_distance_minimum);
            nearNode = nearestNode.isPresent();
        }
        boolean bl = hasModifier = speedAttribute.method_6199(PROXIMITY_SPEED_ID) != null;
        if (nearNode && !hasModifier) {
            class_1322 modifier = new class_1322(PROXIMITY_SPEED_ID, PROXIMITY_SPEED_NAME, CommonConfig.fast_movement_speed, class_1322.class_1323.field_6331);
            speedAttribute.method_26837(modifier);
            lastPathWalkPositions.put(player.method_5667(), player.method_24515());
        } else if (!nearNode && hasModifier) {
            speedAttribute.method_6200(PROXIMITY_SPEED_ID);
            lastPathWalkPositions.remove(player.method_5667());
        } else if (nearNode && hasModifier) {
            class_2338 lastPos = lastPathWalkPositions.get(player.method_5667());
            class_2338 currentPos = player.method_24515();
            if (lastPos == null) {
                lastPathWalkPositions.put(player.method_5667(), currentPos);
            } else if (!lastPos.equals((Object)currentPos)) {
                double distance = Math.sqrt(lastPos.method_10262((class_2382)currentPos));
                player.method_7342(class_3468.field_15419.method_14956((Object)StatInit.DISTANCE_WALKED), (int)(distance * 100.0));
                lastPathWalkPositions.put(player.method_5667(), currentPos);
                int totalDistance = player.method_14248().method_15025(class_3468.field_15419.method_14956((Object)StatInit.DISTANCE_WALKED));
                if ((double)totalDistance >= 500000.0) {
                    SpeedHandler.awardRunningAdvancement(player);
                }
            }
        }
    }

    private static void awardRunningAdvancement(class_3222 player) {
        try {
            class_167 advancementProgress;
            class_161 advancement = player.field_13995.method_3851().method_12896(new class_2960("via_romana:story/i_just_felt_like_running"));
            if (advancement != null && !(advancementProgress = player.method_14236().method_12882(advancement)).method_740()) {
                for (String c : advancementProgress.method_731()) {
                    player.method_14236().method_12878(advancement, c);
                }
            }
        }
        catch (Exception e) {
            ViaRomana.LOGGER.warn("Failed to award advancement {} to player {}: {}", (Object)"via_romana:story/i_just_felt_like_running", (Object)player.method_5477().getString(), (Object)e.getMessage());
        }
    }
}

