/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.state.BlockState;
import net.rasanovum.viaromana.util.VersionUtils;

public class FadeManager {
    private static int fadeUpTicks = 0;
    private static int holdTicks = 0;
    private static int fadeDownTicks = 0;
    private static int footstepInterval = 0;
    private static int currentTick = 0;
    private static boolean active = false;

    private FadeManager() {
    }

    public static boolean isActive() {
        return active;
    }

    public static void startFade(int fadeUp, int hold, int fadeDown, int footstep) {
        fadeUpTicks = fadeUp;
        holdTicks = hold;
        fadeDownTicks = fadeDown;
        footstepInterval = footstep;
        currentTick = 0;
        active = true;
    }

    public static void onClientTick() {
        int totalTicks;
        if (!active) {
            return;
        }
        if (footstepInterval > 0 && ++currentTick % footstepInterval == 0) {
            FadeManager.playFootstep();
        }
        if (currentTick >= (totalTicks = fadeUpTicks + holdTicks + fadeDownTicks)) {
            active = false;
            currentTick = 0;
        }
    }

    public static float getCurrentFadeAlpha() {
        if (!active) {
            return 0.0f;
        }
        int tick = currentTick;
        if (tick < fadeUpTicks) {
            return (float)tick / (float)fadeUpTicks;
        }
        if ((tick -= fadeUpTicks) < holdTicks) {
            return 1.0f;
        }
        if ((tick -= holdTicks) < fadeDownTicks) {
            return 1.0f - (float)tick / (float)fadeDownTicks;
        }
        return 0.0f;
    }

    private static void playFootstep() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ClientLevel level = mc.f_91073_;
        if (player == null || level == null) {
            return;
        }
        BlockPos soundSource = player.m_20097_();
        BlockState blockState = level.m_8055_(soundSource);
        ResourceLocation soundId = BuiltInRegistries.f_256894_.m_7981_((Object)blockState.m_60827_().m_56776_());
        if (soundId == null) {
            soundId = VersionUtils.getLocation("minecraft:block.grass.step");
        }
        level.m_7785_((double)soundSource.m_123341_(), (double)soundSource.m_123342_(), (double)soundSource.m_123343_(), (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(soundId), SoundSource.BLOCKS, 0.2f, 1.0f, false);
    }
}

