/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.gui.elements;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.Nullable;

public class MapSquareButton
extends AbstractButton {
    private final Consumer<MapSquareButton> onPress;
    private final AnimationController animationController;
    private final boolean fixedTooltipPosition;
    private final float hoverBrightness;
    private final float clickBrightness;
    private boolean isPressed = false;
    @Nullable
    private ResourceLocation soundEffectLocation;
    private Component tooltipComponent;
    @Nullable
    private Component disabledTooltipComponent;
    private boolean frozen = false;

    private MapSquareButton(Builder builder) {
        super(builder.x, builder.y, builder.width, builder.height, builder.message);
        this.onPress = builder.onPress;
        this.tooltipComponent = builder.tooltip;
        this.disabledTooltipComponent = builder.disabledTooltip;
        this.fixedTooltipPosition = builder.fixedTooltipPosition;
        this.animationController = new AnimationController(builder);
        this.hoverBrightness = builder.hoverBrightness;
        this.clickBrightness = builder.clickBrightness;
        this.soundEffectLocation = builder.soundEffectLocation;
        this.m_257936_();
    }

    public void setDisabled(boolean disabled) {
        this.f_93623_ = !disabled;
        this.m_257936_();
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
        this.m_257936_();
    }

    public void setTooltip(Component tooltip) {
        this.tooltipComponent = tooltip;
        this.m_257936_();
    }

    public void setTooltips(Component tooltip, @Nullable Component disabledTooltip) {
        this.tooltipComponent = tooltip;
        this.disabledTooltipComponent = disabledTooltip;
        this.m_257936_();
    }

    public void m_5691_() {
        if (this.f_93623_ && !this.frozen && this.onPress != null) {
            this.onPress.accept(this);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.frozen) {
            return false;
        }
        boolean result = super.m_6375_(mouseX, mouseY, button);
        if (result) {
            this.isPressed = true;
        }
        return result;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.frozen) {
            return false;
        }
        boolean result = super.m_6348_(mouseX, mouseY, button);
        this.isPressed = false;
        return result;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.frozen) {
            return false;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    protected boolean m_7972_(int button) {
        if (this.frozen) {
            return false;
        }
        return super.m_7972_(button);
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.f_93624_) {
            return;
        }
        if (!this.frozen) {
            this.animationController.update(this.m_274382_());
        }
        this.renderButtonImage(guiGraphics);
        this.renderButtonText(guiGraphics);
        if (!this.frozen) {
            this.renderFixedTooltip(guiGraphics);
        }
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        this.m_168802_(narrationElementOutput);
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.m_7435_(Minecraft.m_91087_().m_91106_());
        super.m_5716_(mouseX, mouseY);
    }

    public void m_7435_(SoundManager soundManager) {
        if (this.soundEffectLocation != null) {
            SoundEvent soundEvent = SoundEvent.m_262824_((ResourceLocation)this.soundEffectLocation);
            soundManager.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)soundEvent, (float)1.0f));
        } else {
            super.m_7435_(soundManager);
        }
    }

    private void renderButtonImage(GuiGraphics guiGraphics) {
        AnimationController.RenderData data = this.animationController.getRenderData();
        if (data.texture == null) {
            return;
        }
        int imageSize = Math.min(this.f_93618_, this.f_93619_);
        int imageX = this.m_252754_() + (this.f_93618_ - imageSize) / 2;
        int imageY = this.m_252907_() + (this.f_93619_ - imageSize) / 2;
        if (!this.f_93623_) {
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
        } else {
            float multiplier = 1.0f;
            if (this.isPressed) {
                multiplier = this.clickBrightness;
            } else if (this.m_274382_()) {
                multiplier = this.hoverBrightness;
            }
            RenderSystem.setShaderColor((float)multiplier, (float)multiplier, (float)multiplier, (float)1.0f);
        }
        guiGraphics.m_280163_(data.texture, imageX, imageY, (float)data.u, (float)data.v, imageSize, imageSize, data.textureWidth, data.textureHeight);
        if (!this.f_93623_) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderButtonText(GuiGraphics guiGraphics) {
        Font font = Minecraft.m_91087_().f_91062_;
        int textX = this.m_252754_() + (this.f_93618_ - font.m_92852_((FormattedText)this.m_6035_())) / 2;
        int n = this.m_252907_() + this.f_93619_;
        Objects.requireNonNull(font);
        int textY = n - 9 - 2;
        int textColor = this.f_93623_ ? 0xFFFFFF : 0xA0A0A0;
        int strokeColor = this.f_93623_ ? 0 : 0x404040;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                if (dx == 0 && dy == 0) continue;
                guiGraphics.m_280614_(font, this.m_6035_(), textX + dx, textY + dy, strokeColor, false);
            }
        }
        guiGraphics.m_280614_(font, this.m_6035_(), textX, textY, textColor, false);
    }

    private void renderFixedTooltip(GuiGraphics guiGraphics) {
        Component currentTooltip;
        if (this.m_274382_() && this.fixedTooltipPosition && (currentTooltip = this.getActiveTooltip()) != null) {
            Window window = Minecraft.m_91087_().m_91268_();
            int screenWidth = window.m_85445_();
            int screenHeight = window.m_85446_();
            int textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)currentTooltip);
            int x = (screenWidth - textWidth) / 2 - 12;
            int y = screenHeight - ((screenHeight - 256) / 2 + 30) / 2 + 7;
            guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, currentTooltip, x, y);
        }
    }

    private void m_257936_() {
        if (!this.fixedTooltipPosition) {
            if (this.frozen) {
                super.m_257544_(null);
            } else {
                Component currentTooltip = this.getActiveTooltip();
                super.m_257544_(currentTooltip != null ? Tooltip.m_257550_((Component)currentTooltip) : null);
            }
        }
    }

    @Nullable
    private Component getActiveTooltip() {
        return !this.f_93623_ && this.disabledTooltipComponent != null ? this.disabledTooltipComponent : this.tooltipComponent;
    }

    public static class Builder {
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private final Component message;
        private final Consumer<MapSquareButton> onPress;
        private Component tooltip = Component.m_237119_();
        @Nullable
        private Component disabledTooltip = null;
        @Nullable
        private ResourceLocation imageLocation = null;
        @Nullable
        private ResourceLocation animationLocation = null;
        @Nullable
        private ResourceLocation soundEffectLocation = null;
        private int totalFrames = 0;
        private int tileWidth = 0;
        private int tileHeight = 0;
        @Nullable
        private AnimationFrameRange initialHoverAnimation;
        @Nullable
        private AnimationFrameRange hoverLoopAnimation;
        @Nullable
        private AnimationFrameRange mouseOffAnimation;
        private boolean fixedTooltipPosition = false;
        private float hoverBrightness = 1.0f;
        private float clickBrightness = 1.0f;

        public Builder(int x, int y, int width, int height, Component message, Consumer<MapSquareButton> onPress) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.message = message;
            this.onPress = onPress;
        }

        public Builder tooltip(Component tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder tooltips(Component tooltip, @Nullable Component disabledTooltip) {
            this.tooltip = tooltip;
            this.disabledTooltip = disabledTooltip;
            return this;
        }

        public Builder image(ResourceLocation imageLocation, int tileWidth, int tileHeight) {
            this.imageLocation = imageLocation;
            this.tileWidth = tileWidth;
            this.tileHeight = tileHeight;
            return this;
        }

        public Builder animation(ResourceLocation animationLocation, int totalFrames) {
            this.animationLocation = animationLocation;
            this.totalFrames = totalFrames;
            return this;
        }

        public Builder hoverBrightness(float brightness) {
            this.hoverBrightness = brightness;
            return this;
        }

        public Builder clickBrightness(float brightness) {
            this.clickBrightness = brightness;
            return this;
        }

        public Builder soundEffect(ResourceLocation soundLocation) {
            this.soundEffectLocation = soundLocation;
            return this;
        }

        public Builder initialHover(int start, int end, boolean reverse) {
            if (start != -1 && end != -1) {
                this.initialHoverAnimation = new AnimationFrameRange(start, end, reverse ? AnimationDirection.REVERSE : AnimationDirection.FORWARD);
            }
            return this;
        }

        public Builder hoverLoop(int start, int end, boolean reverse) {
            if (start != -1 && end != -1) {
                this.hoverLoopAnimation = new AnimationFrameRange(start, end, reverse ? AnimationDirection.REVERSE : AnimationDirection.FORWARD);
            }
            return this;
        }

        public Builder mouseOff(int start, int end, boolean reverse) {
            if (start != -1 && end != -1) {
                this.mouseOffAnimation = new AnimationFrameRange(start, end, reverse ? AnimationDirection.REVERSE : AnimationDirection.FORWARD);
            }
            return this;
        }

        public Builder fixedTooltipPosition(boolean fixed) {
            this.fixedTooltipPosition = fixed;
            return this;
        }

        public MapSquareButton build() {
            return new MapSquareButton(this);
        }
    }

    private static class AnimationController {
        private final Builder settings;
        private AnimationState currentState = AnimationState.IDLE;
        private boolean wasHovered = false;
        private long animationStartTime = 0L;

        AnimationController(Builder builder) {
            this.settings = builder;
        }

        public void update(boolean isHovered) {
            if (isHovered && !this.wasHovered) {
                this.startAnimation(AnimationState.HOVER_INITIAL);
            } else if (!isHovered && this.wasHovered) {
                this.startAnimation(AnimationState.MOUSE_OFF);
            }
            this.wasHovered = isHovered;
        }

        private void startAnimation(AnimationState state) {
            this.currentState = state;
            this.animationStartTime = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_46467_();
        }

        public RenderData getRenderData() {
            if (this.settings.animationLocation == null || this.currentState == AnimationState.IDLE) {
                return new RenderData(this.settings.imageLocation, 0, 0, this.settings.tileWidth, this.settings.tileHeight);
            }
            long elapsedTicks = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_46467_() - this.animationStartTime;
            AnimationFrameRange activeRange = this.getActiveRange();
            if (activeRange == null) {
                this.currentState = AnimationState.IDLE;
                return new RenderData(this.settings.imageLocation, 0, 0, this.settings.tileWidth, this.settings.tileHeight);
            }
            int frameCount = activeRange.getFrameCount();
            int frameIndex = (int)elapsedTicks;
            boolean loop = this.isLooping();
            if (!loop && frameIndex >= frameCount) {
                if (this.currentState == AnimationState.HOVER_INITIAL) {
                    this.startAnimation(AnimationState.HOVER_LOOP);
                } else if (this.currentState == AnimationState.MOUSE_OFF) {
                    this.currentState = AnimationState.IDLE;
                }
                frameIndex = frameCount - 1;
            }
            int frameOffset = loop ? frameIndex % frameCount : frameIndex;
            int currentFrame = activeRange.direction == AnimationDirection.REVERSE ? activeRange.startFrame - frameOffset : activeRange.startFrame + frameOffset;
            int vOffset = currentFrame * this.settings.tileHeight;
            return new RenderData(this.settings.animationLocation, 0, vOffset, this.settings.tileWidth, this.settings.totalFrames * this.settings.tileHeight);
        }

        private boolean isLooping() {
            return this.currentState == AnimationState.HOVER_LOOP;
        }

        @Nullable
        private AnimationFrameRange getActiveRange() {
            return switch (this.currentState.ordinal()) {
                case 1 -> this.settings.initialHoverAnimation;
                case 2 -> this.settings.hoverLoopAnimation;
                case 3 -> this.settings.mouseOffAnimation;
                default -> null;
            };
        }

        private static enum AnimationState {
            IDLE,
            HOVER_INITIAL,
            HOVER_LOOP,
            MOUSE_OFF;

        }

        record RenderData(@Nullable ResourceLocation texture, int u, int v, int textureWidth, int textureHeight) {
        }
    }

    private record AnimationFrameRange(int startFrame, int endFrame, AnimationDirection direction) {
        int getFrameCount() {
            return Math.abs(this.endFrame - this.startFrame) + 1;
        }
    }

    private static enum AnimationDirection {
        FORWARD,
        REVERSE;

    }
}

