/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.client.gui.MapRenderer;
import net.rasanovum.viaromana.map.ServerMapCache;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.level.LevelDataManager;
import net.rasanovum.viaromana.storage.path.PathDataManager;
import net.rasanovum.viaromana.storage.path.legacy.IPathStorage;
import net.rasanovum.viaromana.storage.player.PlayerData;
import net.rasanovum.viaromana.util.PathSyncUtils;

public class ViaRomanaCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"viaromana").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"nodes").then(Commands.m_82127_((String)"clear").executes(ViaRomanaCommands::clearAllNodes)))).then(Commands.m_82127_((String)"client").then(Commands.m_82127_((String)"clear").executes(ViaRomanaCommands::clearCache)))).then(Commands.m_82127_((String)"convert").then(Commands.m_82127_((String)"legacyPaths").executes(ViaRomanaCommands::convertLegacyPaths)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"maps").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").then(Commands.m_82127_((String)"all").executes(ViaRomanaCommands::clearMaps))).then(Commands.m_82127_((String)"biomePixels").executes(ViaRomanaCommands::clearBiomePixels))).then(Commands.m_82127_((String)"chunkPixels").executes(ViaRomanaCommands::clearChunkPixels)))).then(Commands.m_82127_((String)"regenerate").executes(ViaRomanaCommands::regenerateMaps))).then(Commands.m_82127_((String)"delete").executes(ViaRomanaCommands::deleteMaps))).then(Commands.m_82127_((String)"save").executes(ViaRomanaCommands::saveMaps)))).then(Commands.m_82127_((String)"sync").executes(ViaRomanaCommands::syncDimension)));
    }

    private static int clearAllNodes(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        for (Player player : source.m_81372_().m_6907_()) {
            PlayerData.setChartingPath(player, false);
        }
        PathGraph graph = PathGraph.getInstance(source.m_81372_());
        int nodeCount = graph.size();
        graph.removeAllNodes();
        ClientPathData.getInstance().clearData();
        PathSyncUtils.syncPathGraphToAllPlayers(source.m_81372_());
        PathDataManager.markDirty(source.m_81372_());
        source.m_288197_(() -> Component.m_237115_((String)"command.via_romana.nodes_cleared"), true);
        return nodeCount;
    }

    private static int clearCache(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (source.m_81372_().m_5776_()) {
            ClientPathData.getInstance().clearData();
        }
        PathSyncUtils.syncPathGraphToPlayer(source.m_81375_());
        source.m_288197_(() -> Component.m_237115_((String)"command.via_romana.cache_cleared"), true);
        return 1;
    }

    private static int convertLegacyPaths(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel currentLevel = source.m_81372_();
        PathGraph legacyGraph = IPathStorage.get((Level)currentLevel).graph();
        int legacyNodeCount = legacyGraph.size();
        if (legacyNodeCount == 0) {
            source.m_81352_((Component)Component.m_237115_((String)"command.via_romana.no_legacy_paths"));
            return 0;
        }
        PathGraph currentGraph = PathDataManager.getOrCreatePathGraph(currentLevel);
        if (currentGraph.size() > 0) {
            source.m_81352_((Component)Component.m_237115_((String)"command.via_romana.dimension_has_nodes"));
            return 0;
        }
        CompoundTag serializedData = legacyGraph.serialize(new CompoundTag());
        if (serializedData.m_128441_("nodes")) {
            ListTag nodeList = serializedData.m_128437_("nodes", 10);
            for (int i = 0; i < nodeList.size(); ++i) {
                CompoundTag nodeTag = nodeList.m_128728_(i);
                nodeTag.m_128350_("clearance", 0.0f);
            }
        }
        currentGraph.deserialize(serializedData);
        PathDataManager.markDirty(currentLevel);
        PathSyncUtils.syncPathGraphToAllPlayers(currentLevel);
        source.m_288197_(() -> Component.m_237115_((String)"command.via_romana.legacy_converted"), true);
        return legacyNodeCount;
    }

    private static int clearMaps(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_288197_(() -> Component.m_237115_((String)"command.via_romana.clearing_chunk_data"), false);
        LevelDataManager.clearAllPixelBytes(source.m_81372_());
        LevelDataManager.clearAllCornerBytes(source.m_81372_());
        ServerMapCache.clear();
        ServerMapCache.deleteAllMapsFromDisk();
        if (source.m_81372_().m_5776_()) {
            MapRenderer.clearCache();
        }
        source.m_288197_(() -> Component.m_237115_((String)"command.via_romana.maps_and_chunks_cleared"), true);
        return 1;
    }

    private static int clearBiomePixels(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_288197_(() -> Component.m_237115_((String)"command.via_romana.clearing_biome_data"), false);
        LevelDataManager.clearAllCornerBytes(source.m_81372_());
        ServerMapCache.clear();
        ServerMapCache.deleteAllMapsFromDisk();
        if (source.m_81372_().m_5776_()) {
            MapRenderer.clearCache();
        }
        source.m_288197_(() -> Component.m_237115_((String)"command.via_romana.maps_and_biomes_cleared"), true);
        return 1;
    }

    private static int clearChunkPixels(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_288197_(() -> Component.m_237115_((String)"command.via_romana.clearing_chunk_pixels"), false);
        LevelDataManager.clearAllPixelBytes(source.m_81372_());
        ServerMapCache.clear();
        ServerMapCache.deleteAllMapsFromDisk();
        if (source.m_81372_().m_5776_()) {
            MapRenderer.clearCache();
        }
        source.m_288197_(() -> Component.m_237115_((String)"command.via_romana.maps_and_chunks_cleared"), true);
        return 1;
    }

    private static int regenerateMaps(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_288197_(() -> Component.m_237115_((String)"command.via_romana.regenerating_chunks"), false);
        ServerMapCache.regenerateAllChunkPixelData();
        ServerMapCache.processAllDirtyNetworks(true);
        source.m_288197_(() -> Component.m_237115_((String)"command.via_romana.maps_regenerated"), true);
        return 1;
    }

    private static int deleteMaps(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerMapCache.clear();
        ServerMapCache.deleteAllMapsFromDisk();
        if (source.m_81372_().m_5776_()) {
            MapRenderer.clearCache();
        }
        source.m_288197_(() -> Component.m_237115_((String)"command.via_romana.maps_cleared"), true);
        return 1;
    }

    private static int saveMaps(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerMapCache.saveAllToDisk(true);
        source.m_288197_(() -> Component.m_237115_((String)"command.via_romana.maps_saved"), true);
        return 1;
    }

    private static int syncDimension(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.m_81372_();
        PathSyncUtils.syncPathGraphToAllPlayers(level);
        source.m_288197_(() -> Component.m_237115_((String)"command.via_romana.sync_triggered"), true);
        return 1;
    }
}

