/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.mixins;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.rasanovum.viaromana.map.ServerMapCache;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.level.LevelDataManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin {
    @Inject(method={"onBlockStateChange(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;)V"}, at={@At(value="HEAD")})
    private void onBlockStateChange(BlockPos pos, BlockState oldState, BlockState newState, CallbackInfo ci) {
        if (oldState == newState) {
            return;
        }
        ServerLevel world = (ServerLevel)this;
        ChunkPos chunkPos = new ChunkPos(pos);
        if (!LevelDataManager.isPixelChunkTracked(world, chunkPos)) {
            return;
        }
        if (oldState.m_284242_((BlockGetter)world, pos).equals(newState.m_284242_((BlockGetter)world, pos))) {
            return;
        }
        LevelChunk levelChunk = world.m_7726_().m_7131_(chunkPos.f_45578_, chunkPos.f_45579_);
        if (levelChunk == null) {
            return;
        }
        int localX = pos.m_123341_() & 0xF;
        int localZ = pos.m_123343_() & 0xF;
        int surfaceY = levelChunk.m_5885_(Heightmap.Types.MOTION_BLOCKING, localX, localZ);
        if (pos.m_123342_() < surfaceY - 1) {
            return;
        }
        if (newState.m_60812_((BlockGetter)world, pos).m_83281_() && oldState.m_60812_((BlockGetter)world, pos).m_83281_()) {
            return;
        }
        PathGraph graph = PathGraph.getInstance(world);
        if (graph == null) {
            return;
        }
        List<PathGraph.NetworkCache> networks = graph.findNetworksForChunk(chunkPos);
        if (networks.isEmpty()) {
            return;
        }
        ServerMapCache.markChunkDirty(world, chunkPos, networks);
    }
}

