/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.util.VersionUtils;

public record DestinationResponseS2C(List<DestinationInfo> destinations, BlockPos signPos, BlockPos sourceNodePos, List<NodeNetworkInfo> networkNodes, UUID networkId) {
    public static final ResourceLocation TYPE = VersionUtils.getLocation("via_romana:destination_response");
    public static final Object STREAM_CODEC = null;

    public static void encode(FriendlyByteBuf buf, DestinationResponseS2C packet) {
        buf.m_130064_(packet.signPos);
        buf.m_130064_(packet.sourceNodePos);
        buf.m_130077_(packet.networkId);
        buf.writeInt(packet.destinations.size());
        for (DestinationInfo dest : packet.destinations) {
            buf.m_130064_(dest.position);
            buf.m_130070_(dest.name);
            buf.writeDouble(dest.distance);
            buf.m_130070_(dest.icon.name());
        }
        buf.writeInt(packet.networkNodes.size());
        for (NodeNetworkInfo node : packet.networkNodes) {
            buf.m_130064_(node.position);
            buf.writeFloat(node.clearance);
            buf.writeInt(node.connections.size());
            for (BlockPos connection : node.connections) {
                buf.m_130064_(connection);
            }
        }
    }

    public static DestinationResponseS2C decode(FriendlyByteBuf buf) {
        BlockPos signPos = buf.m_130135_();
        BlockPos sourceNodePos = buf.m_130135_();
        UUID networkId = buf.m_130259_();
        int size = buf.readInt();
        ArrayList<DestinationInfo> destinations = new ArrayList<DestinationInfo>(size);
        for (int i = 0; i < size; ++i) {
            destinations.add(new DestinationInfo(buf.m_130135_(), buf.m_130277_(), buf.readDouble(), Node.Icon.valueOf(buf.m_130277_())));
        }
        int networkSize = buf.readInt();
        ArrayList<NodeNetworkInfo> networkNodes = new ArrayList<NodeNetworkInfo>(networkSize);
        for (int i = 0; i < networkSize; ++i) {
            BlockPos pos = buf.m_130135_();
            float clearance = buf.readFloat();
            int connectionCount = buf.readInt();
            ArrayList<BlockPos> connections = new ArrayList<BlockPos>(connectionCount);
            for (int j = 0; j < connectionCount; ++j) {
                connections.add(buf.m_130135_());
            }
            networkNodes.add(new NodeNetworkInfo(pos, clearance, connections));
        }
        return new DestinationResponseS2C(destinations, signPos, sourceNodePos, networkNodes, networkId);
    }

    public static class DestinationInfo {
        public final BlockPos position;
        public final String name;
        public final double distance;
        public final Node.Icon icon;

        public DestinationInfo(BlockPos position, String name, double distance, Node.Icon icon) {
            this.position = position;
            this.name = name;
            this.distance = distance;
            this.icon = icon;
        }
    }

    public static class NodeNetworkInfo {
        public final BlockPos position;
        public final float clearance;
        public final List<BlockPos> connections;

        public NodeNetworkInfo(BlockPos position, float clearance, List<BlockPos> connections) {
            this.position = position;
            this.clearance = clearance;
            this.connections = connections;
        }
    }
}

