/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.core.LinkHandler;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.util.VersionUtils;

public record SignLinkRequestC2S(LinkHandler.LinkData linkData, boolean isTempNode) {
    public static final ResourceLocation TYPE = VersionUtils.getLocation("via_romana:link_sign_request");
    public static final Object STREAM_CODEC = null;

    public static void encode(FriendlyByteBuf buf, SignLinkRequestC2S packet) {
        buf.m_130064_(packet.linkData.nodePos());
        buf.m_130064_(packet.linkData.signPos());
        buf.m_130068_((Enum)packet.linkData.linkType());
        buf.writeBoolean(packet.linkData.owner() != null);
        if (packet.linkData.owner() != null) {
            buf.m_130077_(packet.linkData.owner());
        }
        buf.m_130070_(packet.linkData.destinationName());
        buf.m_130068_((Enum)packet.linkData.icon());
        buf.writeBoolean(packet.isTempNode);
    }

    public static SignLinkRequestC2S decode(FriendlyByteBuf buf) {
        BlockPos nodePos = buf.m_130135_();
        BlockPos signPos = buf.m_130135_();
        Node.LinkType linkType = (Node.LinkType)buf.m_130066_(Node.LinkType.class);
        UUID owner = buf.readBoolean() ? buf.m_130259_() : null;
        String destinationName = buf.m_130277_();
        Node.Icon icon = (Node.Icon)buf.m_130066_(Node.Icon.class);
        LinkHandler.LinkData linkData = new LinkHandler.LinkData(signPos, nodePos, linkType, icon, destinationName, owner);
        boolean isTempNode = buf.readBoolean();
        return new SignLinkRequestC2S(linkData, isTempNode);
    }

    public static void handle(PacketContext<SignLinkRequestC2S> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            LinkHandler.LinkData linkData;
            ServerLevel level = ctx.sender().m_284548_();
            boolean success = LinkHandler.linkSignToNode(level, linkData = ((SignLinkRequestC2S)ctx.message()).linkData());
            if (!success) {
                ViaRomana.LOGGER.warn("Failed to link sign at {} to node at {} for player {}", (Object)linkData.signPos(), (Object)linkData.nodePos(), (Object)ctx.sender().m_7755_().getString());
            } else if (CommonConfig.logging_enum.ordinal() > 0) {
                ViaRomana.LOGGER.info("Successfully linked sign at {} to node at {} for player {}", (Object)linkData.signPos(), (Object)linkData.nodePos(), (Object)ctx.sender().m_7755_().getString());
            }
        }
    }
}

