/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import commonnetwork.api.Dispatcher;
import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.network.packets.SignValidationResponseS2C;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.util.VersionUtils;

public record SignValidationRequestC2S(BlockPos nodePos) {
    public static final ResourceLocation TYPE = VersionUtils.getLocation("viaromana:sign_validation_c2s");
    public static final Object STREAM_CODEC = null;

    public static void encode(FriendlyByteBuf buf, SignValidationRequestC2S packet) {
        buf.m_130064_(packet.nodePos);
    }

    public static SignValidationRequestC2S decode(FriendlyByteBuf buf) {
        return new SignValidationRequestC2S(buf.m_130135_());
    }

    public static void handle(PacketContext<SignValidationRequestC2S> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            ServerLevel level = ctx.sender().m_284548_();
            BlockPos nodePos = ((SignValidationRequestC2S)ctx.message()).nodePos();
            PathGraph graph = PathGraph.getInstance(level);
            boolean isValid = graph.getNodeAt(nodePos).isPresent();
            if (CommonConfig.logging_enum.ordinal() > 0 && !isValid) {
                ViaRomana.LOGGER.info("Validation failed for destination at {}", (Object)nodePos);
            }
            SignValidationResponseS2C response = new SignValidationResponseS2C(nodePos, isValid);
            Dispatcher.sendToClient((Object)response, (ServerPlayer)ctx.sender());
        }
    }
}

