/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana;

import com.google.common.collect.Lists;
import eu.midnightdust.lib.config.MidnightConfig;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.PackResources;
import net.rasanovum.viaromana.ViaRomana;

public class CommonConfig
extends MidnightConfig {
    public static final String CHARTING = "charting";
    public static final String MAP = "map";
    public static final String WARP = "warp";
    public static final String VISUALS = "visuals";
    @MidnightConfig.Entry(category="charting", min=1.0)
    public static int infrastructure_check_radius = 2;
    @MidnightConfig.Entry(category="charting", min=0.0, max=1.0)
    public static float path_quality_threshold = 0.3f;
    @MidnightConfig.Entry(category="charting", min=1.0)
    public static int node_distance_minimum = 4;
    @MidnightConfig.Entry(category="charting", min=2.0)
    public static int node_distance_maximum = 8;
    @MidnightConfig.Entry(category="charting", min=1.0)
    public static int node_utility_distance = 3;
    @MidnightConfig.Entry(category="charting")
    public static List<String> path_block_ids = Lists.newArrayList((Object[])new String[]{"minecraft:dirt_path", "minecraft:packed_mud", "minecraft:coarse_dirt", "minecraft:rooted_dirt"});
    @MidnightConfig.Entry(category="charting")
    public static List<String> path_block_tags = Lists.newArrayList();
    @MidnightConfig.Entry(category="charting")
    public static List<String> path_block_strings = Lists.newArrayList((Object[])new String[]{"sandstone", "polished", "cobble", "brick", "smooth", "basalt", "path", "road", "concrete", "pavement", "glazed", "tile", "_wall", "_fence", "_slab", "_stairs", "_wool", "_carpet", "_plank", "_log", "_wood", "rail", "_button", "_pressure_plate"});
    @MidnightConfig.Entry(category="charting")
    public static List<String> block_string_blacklist = Lists.newArrayList((Object[])new String[]{"diagonalwalls:", "diagonalfences:", "diagonalwindows:"});
    @MidnightConfig.Entry(category="charting")
    public static List<String> invalid_dimensions = Lists.newArrayList();
    @MidnightConfig.Comment(category="charting")
    public static MidnightConfig.Comment charting_footer;
    @MidnightConfig.Entry(category="warp")
    public static List<String> invalid_entities;
    @MidnightConfig.Entry(category="warp")
    public static List<String> warp_block_ids;
    @MidnightConfig.Entry(category="warp")
    public static List<String> warp_block_tags;
    @MidnightConfig.Entry(category="warp", min=0.0)
    public static int travel_fatigue_cooldown;
    @MidnightConfig.Comment(category="warp")
    public static MidnightConfig.Comment warp_footer;
    @MidnightConfig.Entry(category="map", min=1.0)
    public static int fog_of_war_distance;
    @MidnightConfig.Entry(category="map", min=0.0, max=200.0)
    public static float spline_animation_speed;
    @MidnightConfig.Entry(category="map", min=128.0)
    public static int maximum_map_dimension;
    @MidnightConfig.Entry(category="map", min=0.0)
    public static int map_refresh_interval;
    @MidnightConfig.Entry(category="map", min=0.0)
    public static int map_save_interval;
    @MidnightConfig.Entry(category="map")
    public static List<String> biomeColor;
    @MidnightConfig.Entry(category="map")
    public static boolean use_biome_fallback_for_lowres;
    @MidnightConfig.Entry(category="map")
    public static boolean enable_surveyor_landmark;
    @MidnightConfig.Entry(category="map")
    public static boolean enable_surveyor_landmark_coloring;
    @MidnightConfig.Comment(category="map")
    public static MidnightConfig.Comment map_footer;
    @MidnightConfig.Entry(category="visuals", min=0.0, max=1.0)
    public static float invalid_block_overlay_opacity;
    @MidnightConfig.Entry(category="visuals", min=0.0, max=1.0)
    public static float biome_map_opacity;
    @MidnightConfig.Entry(category="visuals", min=0.0, max=1.0)
    public static float node_vignette_opacity;
    @MidnightConfig.Entry(category="visuals")
    public static boolean enable_teleport_particles;

    public void writeChanges(String modid) {
        System.out.println("Config save triggered for mod: " + modid);
        super.writeChanges(modid);
        MinecraftServer server = ViaRomana.getServer();
        if (server == null) {
            return;
        }
        server.execute(() -> {
            ViaRomana.LOGGER.info("Reloading server resources due to config change...");
            server.reloadResources(server.getResourceManager().listPacks().map(PackResources::packId).toList());
        });
    }

    static {
        invalid_entities = Lists.newArrayList();
        warp_block_ids = Lists.newArrayList((Object[])new String[]{"via_romana:warp_block"});
        warp_block_tags = Lists.newArrayList((Object[])new String[]{"minecraft:all_signs"});
        travel_fatigue_cooldown = 10;
        fog_of_war_distance = 10;
        spline_animation_speed = 2.0f;
        maximum_map_dimension = 512;
        map_refresh_interval = 10;
        map_save_interval = 5;
        biomeColor = Lists.newArrayList();
        use_biome_fallback_for_lowres = true;
        enable_surveyor_landmark = false;
        enable_surveyor_landmark_coloring = false;
        invalid_block_overlay_opacity = 0.4f;
        biome_map_opacity = 0.3f;
        node_vignette_opacity = 1.0f;
        enable_teleport_particles = true;
    }
}

