/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client;

import com.mojang.blaze3d.platform.NativeImage;
import commonnetwork.api.Dispatcher;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.material.MapColor;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.map.MapInfo;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;
import net.rasanovum.viaromana.network.packets.MapRequestC2S;
import net.rasanovum.viaromana.network.packets.MapResponseS2C;

public class MapClient {
    private static CompletableFuture<MapInfo> pendingRequest = null;

    public static CompletableFuture<MapInfo> requestMap(UUID networkId, BlockPos minBounds, BlockPos maxBounds, List<DestinationResponseS2C.NodeNetworkInfo> networkNodes) {
        CompletableFuture<MapInfo> future = new CompletableFuture<MapInfo>();
        pendingRequest = future;
        MapRequestC2S packet = MapRequestC2S.create(networkId, minBounds, maxBounds, networkNodes);
        Dispatcher.sendToServer((Object)packet);
        return future;
    }

    public static void handleMapResponse(MapResponseS2C packet) {
        MapClient.handleMapInfo(packet.getMapInfo());
    }

    public static void handleMapInfo(MapInfo mapInfo) {
        if (pendingRequest != null) {
            pendingRequest.complete(mapInfo);
            pendingRequest = null;
        }
    }

    public static MapTexture createTexture(MapInfo mapInfo) {
        if (mapInfo == null || mapInfo.biomePixels() == null || mapInfo.pixelWidth() == 0 || mapInfo.pixelHeight() == 0) {
            return null;
        }
        try {
            int argb;
            int packedId;
            int idx;
            int x;
            int y;
            long startTime = System.nanoTime();
            int width = mapInfo.pixelWidth();
            int height = mapInfo.pixelHeight();
            byte[] biomePixels = mapInfo.biomePixels();
            byte[] chunkPixels = mapInfo.chunkPixels() != null ? mapInfo.chunkPixels() : new byte[biomePixels.length];
            long createImageStart = System.nanoTime();
            NativeImage biomeImage = new NativeImage(width, height, false);
            NativeImage chunkImage = new NativeImage(width, height, false);
            long createImageTime = System.nanoTime() - createImageStart;
            long convertStart = System.nanoTime();
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    idx = x + y * width;
                    packedId = biomePixels[idx] & 0xFF;
                    argb = MapColor.getColorFromPackedId((int)packedId);
                    biomeImage.setPixelRGBA(x, y, argb);
                }
            }
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    idx = x + y * width;
                    packedId = chunkPixels[idx] & 0xFF;
                    if (packedId != 0) {
                        argb = MapColor.getColorFromPackedId((int)packedId);
                        chunkImage.setPixelRGBA(x, y, argb);
                        continue;
                    }
                    chunkImage.setPixelRGBA(x, y, 0);
                }
            }
            long convertTime = System.nanoTime() - convertStart;
            long totalTime = System.nanoTime() - startTime;
            ViaRomana.LOGGER.debug("[PERF-CLIENT] Created raw map images for network {}: total={}ms, create={}ms, convert={}ms, dimensions={}x{}, pixels={}", (Object)mapInfo.networkId(), (Object)((double)totalTime / 1000000.0), (Object)((double)createImageTime / 1000000.0), (Object)((double)convertTime / 1000000.0), (Object)width, (Object)height, (Object)biomePixels.length);
            return new MapTexture(mapInfo, biomeImage, chunkImage);
        }
        catch (Exception e) {
            ViaRomana.LOGGER.error("MapClient: Failed to create texture for network {}: {}", (Object)mapInfo.networkId(), (Object)e.getMessage());
            return null;
        }
    }

    public record MapTexture(MapInfo mapInfo, NativeImage biomeImage, NativeImage chunkImage) implements AutoCloseable
    {
        @Override
        public void close() {
            if (this.biomeImage != null) {
                this.biomeImage.close();
            }
            if (this.chunkImage != null) {
                this.chunkImage.close();
            }
        }
    }
}

