/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.gui;

import commonnetwork.api.Dispatcher;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.client.gui.elements.MapActionButton;
import net.rasanovum.viaromana.client.gui.elements.MapButtonGroup;
import net.rasanovum.viaromana.client.gui.elements.MapCycleButton;
import net.rasanovum.viaromana.client.gui.elements.MapEditBox;
import net.rasanovum.viaromana.client.gui.elements.MapIconButton;
import net.rasanovum.viaromana.client.gui.elements.MapIconButtonGroup;
import net.rasanovum.viaromana.client.gui.elements.MapSignatureButton;
import net.rasanovum.viaromana.core.LinkHandler;
import net.rasanovum.viaromana.network.packets.SignLinkRequestC2S;
import net.rasanovum.viaromana.network.packets.SignUnlinkRequestC2S;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.util.VersionUtils;

@OnlyIn(value=Dist.CLIENT)
public class LinkSignScreen
extends Screen {
    private static final int BACKGROUND_WIDTH = 256;
    private static final int BACKGROUND_HEIGHT = 256;
    private static final int USABLE_WIDTH = 230;
    private static final int USABLE_HEIGHT = 160;
    private static final ResourceLocation BACKGROUND_TEXTURE = VersionUtils.getLocation("via_romana:textures/screens/background_map.png");
    private final BlockPos nodePos;
    private final BlockPos signPos;
    private final UUID playerUuid;
    private final String playerName;
    private final boolean isTempNode;
    private final boolean isSignLinked;
    private MapEditBox destinationNameField;
    private MapButtonGroup<Node.LinkType> linkTypeButtonGroup;
    private MapCycleButton<Node.LinkType> destinationButton;
    private MapCycleButton<Node.LinkType> privateButton;
    private MapCycleButton<Node.LinkType> accessButton;
    private MapIconButtonGroup iconButtonGroup;
    private MapSignatureButton signatureButton;
    private MapActionButton unlinkButton;
    private String destinationName = "Travel Destination";
    private Node.LinkType linkType = Node.LinkType.DESTINATION;
    private Node.Icon icon = Node.Icon.SIGNPOST;

    public LinkSignScreen(Player player, LinkHandler.LinkData linkData, boolean isTempNode, boolean isSignLinked) {
        super((Component)Component.translatable((String)"gui.viaromana.configure_sign_link.title"));
        this.playerUuid = player.getUUID();
        this.playerName = player.getName().getString();
        this.signPos = linkData.signPos();
        this.nodePos = linkData.nodePos();
        this.linkType = linkData.linkType() != null ? linkData.linkType() : Node.LinkType.DESTINATION;
        this.icon = linkData.icon() != null ? linkData.icon() : Node.Icon.SIGNPOST;
        this.destinationName = linkData.destinationName() != null ? linkData.destinationName() : "Travel Destination";
        this.isTempNode = isTempNode;
        this.isSignLinked = isSignLinked;
    }

    protected void init() {
        super.init();
        int panelX = (this.width - 256) / 2;
        int panelY = (this.height - 256) / 2;
        int usableX = panelX + 13;
        int usableY = panelY + 48;
        this.destinationNameField = new MapEditBox(this.font, usableX + 10, (usableY -= 8) + 30, 210, 20, (Component)Component.translatable((String)"gui.viaromana.destination_name"));
        this.destinationNameField.setValue(this.destinationName);
        this.destinationNameField.setMaxLength(50);
        this.destinationNameField.setTextColor(4139547);
        this.addRenderableWidget((GuiEventListener)this.destinationNameField);
        this.linkTypeButtonGroup = new MapButtonGroup<Node.LinkType>(value -> {
            this.linkType = value;
        });
        int buttonWidth = 75;
        int buttonHeight = 16;
        int buttonStartX = usableX + 10;
        this.destinationButton = new MapCycleButton<Node.LinkType>(this.font, buttonStartX, usableY + 74, buttonWidth, buttonHeight, Arrays.asList(Node.LinkType.DESTINATION), Node.LinkType.DESTINATION, linkType -> Component.translatable((String)"gui.viaromana.destination_button"), null, (Component)Component.translatable((String)"gui.viaromana.destination_tooltip"));
        this.privateButton = new MapCycleButton<Node.LinkType>(this.font, buttonStartX, usableY + 94, buttonWidth, buttonHeight, Arrays.asList(Node.LinkType.PRIVATE), Node.LinkType.PRIVATE, linkType -> Component.translatable((String)"gui.viaromana.private_button"), null, (Component)Component.translatable((String)"gui.viaromana.private_tooltip"));
        this.accessButton = new MapCycleButton<Node.LinkType>(this.font, buttonStartX, usableY + 114, buttonWidth, buttonHeight, Arrays.asList(Node.LinkType.ACCESS), Node.LinkType.ACCESS, linkType -> Component.translatable((String)"gui.viaromana.access_button"), null, (Component)Component.translatable((String)"gui.viaromana.access_tooltip"));
        this.linkTypeButtonGroup.addButton(this.destinationButton);
        this.linkTypeButtonGroup.addButton(this.privateButton);
        this.linkTypeButtonGroup.addButton(this.accessButton);
        this.linkTypeButtonGroup.selectByValue(this.linkType);
        this.addRenderableWidget((GuiEventListener)this.destinationButton);
        this.addRenderableWidget((GuiEventListener)this.privateButton);
        this.addRenderableWidget((GuiEventListener)this.accessButton);
        int iconGridX = usableX + 115 - 20;
        int iconGridY = usableY + 70;
        this.iconButtonGroup = new MapIconButtonGroup(value -> {
            this.icon = value;
        });
        List<MapIconButton> iconButtons = this.iconButtonGroup.createIconButtons(this.font, iconGridX, iconGridY, 4, 0);
        for (MapIconButton iconBtn : iconButtons) {
            this.addRenderableWidget((GuiEventListener)iconBtn);
        }
        this.iconButtonGroup.selectByIcon(this.icon);
        this.signatureButton = new MapSignatureButton(this.font, usableX + 10, usableY + 146, 130, this.playerName, value -> this.confirmLinking());
        this.addRenderableWidget((GuiEventListener)this.signatureButton);
        if (this.isSignLinked) {
            int unlinkButtonWidth = 60;
            int unlinkButtonHeight = 16;
            this.unlinkButton = new MapActionButton(usableX + 230 - unlinkButtonWidth - 10, usableY + 148, unlinkButtonWidth, unlinkButtonHeight, (Component)Component.translatable((String)"gui.viaromana.unlink_button"), (Component)Component.translatable((String)"gui.viaromana.unlink_tooltip"), value -> {
                Dispatcher.sendToServer((Object)new SignUnlinkRequestC2S(this.signPos));
                this.onClose();
            }, VersionUtils.getLocation("via_romana:textures/screens/element_unlink.png"));
            this.addRenderableWidget((GuiEventListener)this.unlinkButton);
        }
        this.setInitialFocus((GuiEventListener)this.destinationNameField);
    }

    public void tick() {
        super.tick();
        this.destinationNameField.tick();
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        int panelX = (this.width - 256) / 2;
        int panelY = (this.height - 256) / 2;
        int usableX = panelX + 13;
        int usableY = panelY + 48;
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(BACKGROUND_TEXTURE, panelX, panelY, 0.0f, 0.0f, 256, 256, 256, 256);
        MutableComponent title = Component.translatable((String)"gui.viaromana.configure_sign_link.title");
        int titleWidth = this.font.width((FormattedText)title);
        guiGraphics.drawString(this.font, (Component)title, usableX + (230 - titleWidth) / 2, (usableY -= 8) + 10, 4139547, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.viaromana.name_label"), usableX + 10, usableY + 20, 4139547, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.viaromana.type_label"), usableX + 10, usableY + 60, 4139547, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.viaromana.icon_label"), usableX + 115 - 20, usableY + 60, 4139547, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.viaromana.signature_label"), usableX + 10, usableY + 138, 4139547, false);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void confirmLinking() {
        Node.Icon selectedIcon;
        Node.LinkType selectedLinkType;
        String finalName = this.destinationNameField.getValue().trim();
        if (finalName.isEmpty()) {
            finalName = Component.translatable((String)"gui.viaromana.default_destination_name").getString();
        }
        if ((selectedLinkType = this.linkType) == null) {
            selectedLinkType = Node.LinkType.DESTINATION;
        }
        if ((selectedIcon = this.icon) == null) {
            selectedIcon = Node.Icon.SIGNPOST;
        }
        UUID owner = selectedLinkType == Node.LinkType.PRIVATE ? this.playerUuid : null;
        LinkHandler.LinkData linkData = new LinkHandler.LinkData(this.signPos, this.nodePos, selectedLinkType, selectedIcon, finalName, owner);
        SignLinkRequestC2S packet = new SignLinkRequestC2S(linkData, this.isTempNode);
        Dispatcher.sendToServer((Object)packet);
        ClientPathData clientPathData = ClientPathData.getInstance();
        boolean isTargetNodeTemp = clientPathData.isTemporaryNode(this.nodePos);
        boolean hasExistingTempLink = clientPathData.getTemporarySignLink(this.signPos).isPresent();
        if (isTargetNodeTemp || hasExistingTempLink) {
            clientPathData.addTemporaryLink(linkData);
        } else if (hasExistingTempLink && !isTargetNodeTemp) {
            clientPathData.getTemporarySignLink(this.signPos).ifPresent(clientPathData::removeTemporaryLink);
        }
        this.onClose();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 && this.destinationNameField.isFocused()) {
            this.confirmLinking();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

