/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.rasanovum.viaromana.util.VersionUtils;

@OnlyIn(value=Dist.CLIENT)
public class WarpBlockScreen
extends Screen {
    private static final ResourceLocation WARP_BLOCK_TEXTURE = VersionUtils.getLocation("via_romana:textures/screens/warp_block_texture.png");
    private final BlockPos blockPos;

    public WarpBlockScreen(BlockPos blockPos) {
        super((Component)Component.translatable((String)"gui.viaromana.warp_block.title"));
        this.blockPos = blockPos;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    protected void init() {
        super.init();
        Button doneButton = Button.builder((Component)Component.literal((String)"Done"), button -> this.onClose()).bounds(this.width / 2 - 100, this.height / 4 + 120 + 24, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)doneButton);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        Component title = this.getTitle();
        int titleWidth = this.font.width((FormattedText)title);
        guiGraphics.drawString(this.font, title, (this.width - titleWidth) / 2, 20, 0xFFFFFF);
        int textureSize = 128;
        int drawX = (this.width - textureSize) / 2;
        int drawY = (this.height - textureSize) / 2 - 18;
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(WARP_BLOCK_TEXTURE, drawX, drawY, 0.0f, 0.0f, textureSize, textureSize, 128, 128);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

