/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.gui.elements;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.Nullable;

public class MapSquareButton
extends AbstractButton {
    private final Consumer<MapSquareButton> onPress;
    private final AnimationController animationController;
    private final boolean fixedTooltipPosition;
    private final float hoverBrightness;
    private final float clickBrightness;
    private boolean isPressed = false;
    @Nullable
    private ResourceLocation soundEffectLocation;
    private Component tooltipComponent;
    @Nullable
    private Component disabledTooltipComponent;
    private boolean frozen = false;

    private MapSquareButton(Builder builder) {
        super(builder.x, builder.y, builder.width, builder.height, builder.message);
        this.onPress = builder.onPress;
        this.tooltipComponent = builder.tooltip;
        this.disabledTooltipComponent = builder.disabledTooltip;
        this.fixedTooltipPosition = builder.fixedTooltipPosition;
        this.animationController = new AnimationController(builder);
        this.hoverBrightness = builder.hoverBrightness;
        this.clickBrightness = builder.clickBrightness;
        this.soundEffectLocation = builder.soundEffectLocation;
        this.updateTooltip();
    }

    public void setDisabled(boolean disabled) {
        this.active = !disabled;
        this.updateTooltip();
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
        this.updateTooltip();
    }

    public void setTooltip(Component tooltip) {
        this.tooltipComponent = tooltip;
        this.updateTooltip();
    }

    public void setTooltips(Component tooltip, @Nullable Component disabledTooltip) {
        this.tooltipComponent = tooltip;
        this.disabledTooltipComponent = disabledTooltip;
        this.updateTooltip();
    }

    public void onPress() {
        if (this.active && !this.frozen && this.onPress != null) {
            this.onPress.accept(this);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.frozen) {
            return false;
        }
        boolean result = super.mouseClicked(mouseX, mouseY, button);
        if (result) {
            this.isPressed = true;
        }
        return result;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.frozen) {
            return false;
        }
        boolean result = super.mouseReleased(mouseX, mouseY, button);
        this.isPressed = false;
        return result;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.frozen) {
            return false;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    protected boolean isValidClickButton(int button) {
        if (this.frozen) {
            return false;
        }
        return super.isValidClickButton(button);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.visible) {
            return;
        }
        if (!this.frozen) {
            this.animationController.update(this.isHovered());
        }
        this.renderButtonImage(guiGraphics);
        this.renderButtonText(guiGraphics);
        if (!this.frozen) {
            this.renderFixedTooltip(guiGraphics);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }

    public void onClick(double mouseX, double mouseY) {
        this.playDownSound(Minecraft.getInstance().getSoundManager());
        super.onClick(mouseX, mouseY);
    }

    public void playDownSound(SoundManager soundManager) {
        if (this.soundEffectLocation != null) {
            SoundEvent soundEvent = SoundEvent.createVariableRangeEvent((ResourceLocation)this.soundEffectLocation);
            soundManager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)soundEvent, (float)1.0f));
        } else {
            super.playDownSound(soundManager);
        }
    }

    private void renderButtonImage(GuiGraphics guiGraphics) {
        AnimationController.RenderData data = this.animationController.getRenderData();
        if (data.texture == null) {
            return;
        }
        int imageSize = Math.min(this.width, this.height);
        int imageX = this.getX() + (this.width - imageSize) / 2;
        int imageY = this.getY() + (this.height - imageSize) / 2;
        if (!this.active) {
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
        } else {
            float multiplier = 1.0f;
            if (this.isPressed) {
                multiplier = this.clickBrightness;
            } else if (this.isHovered()) {
                multiplier = this.hoverBrightness;
            }
            RenderSystem.setShaderColor((float)multiplier, (float)multiplier, (float)multiplier, (float)1.0f);
        }
        guiGraphics.blit(data.texture, imageX, imageY, (float)data.u, (float)data.v, imageSize, imageSize, data.textureWidth, data.textureHeight);
        if (!this.active) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderButtonText(GuiGraphics guiGraphics) {
        Font font = Minecraft.getInstance().font;
        int textX = this.getX() + (this.width - font.width((FormattedText)this.getMessage())) / 2;
        int n = this.getY() + this.height;
        Objects.requireNonNull(font);
        int textY = n - 9 - 2;
        int textColor = this.active ? 0xFFFFFF : 0xA0A0A0;
        int strokeColor = this.active ? 0 : 0x404040;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                if (dx == 0 && dy == 0) continue;
                guiGraphics.drawString(font, this.getMessage(), textX + dx, textY + dy, strokeColor, false);
            }
        }
        guiGraphics.drawString(font, this.getMessage(), textX, textY, textColor, false);
    }

    private void renderFixedTooltip(GuiGraphics guiGraphics) {
        Component currentTooltip;
        if (this.isHovered() && this.fixedTooltipPosition && (currentTooltip = this.getActiveTooltip()) != null) {
            Window window = Minecraft.getInstance().getWindow();
            int screenWidth = window.getGuiScaledWidth();
            int screenHeight = window.getGuiScaledHeight();
            int textWidth = Minecraft.getInstance().font.width((FormattedText)currentTooltip);
            int x = (screenWidth - textWidth) / 2 - 12;
            int y = screenHeight - ((screenHeight - 256) / 2 + 30) / 2 + 7;
            guiGraphics.renderTooltip(Minecraft.getInstance().font, currentTooltip, x, y);
        }
    }

    private void updateTooltip() {
        if (!this.fixedTooltipPosition) {
            if (this.frozen) {
                super.setTooltip(null);
            } else {
                Component currentTooltip = this.getActiveTooltip();
                super.setTooltip(currentTooltip != null ? Tooltip.create((Component)currentTooltip) : null);
            }
        }
    }

    @Nullable
    private Component getActiveTooltip() {
        return !this.active && this.disabledTooltipComponent != null ? this.disabledTooltipComponent : this.tooltipComponent;
    }

    public static class Builder {
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private final Component message;
        private final Consumer<MapSquareButton> onPress;
        private Component tooltip = Component.empty();
        @Nullable
        private Component disabledTooltip = null;
        @Nullable
        private ResourceLocation imageLocation = null;
        @Nullable
        private ResourceLocation animationLocation = null;
        @Nullable
        private ResourceLocation soundEffectLocation = null;
        private int totalFrames = 0;
        private int tileWidth = 0;
        private int tileHeight = 0;
        @Nullable
        private AnimationFrameRange initialHoverAnimation;
        @Nullable
        private AnimationFrameRange hoverLoopAnimation;
        @Nullable
        private AnimationFrameRange mouseOffAnimation;
        private boolean fixedTooltipPosition = false;
        private float hoverBrightness = 1.0f;
        private float clickBrightness = 1.0f;

        public Builder(int x, int y, int width, int height, Component message, Consumer<MapSquareButton> onPress) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.message = message;
            this.onPress = onPress;
        }

        public Builder tooltip(Component tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder tooltips(Component tooltip, @Nullable Component disabledTooltip) {
            this.tooltip = tooltip;
            this.disabledTooltip = disabledTooltip;
            return this;
        }

        public Builder image(ResourceLocation imageLocation, int tileWidth, int tileHeight) {
            this.imageLocation = imageLocation;
            this.tileWidth = tileWidth;
            this.tileHeight = tileHeight;
            return this;
        }

        public Builder animation(ResourceLocation animationLocation, int totalFrames) {
            this.animationLocation = animationLocation;
            this.totalFrames = totalFrames;
            return this;
        }

        public Builder hoverBrightness(float brightness) {
            this.hoverBrightness = brightness;
            return this;
        }

        public Builder clickBrightness(float brightness) {
            this.clickBrightness = brightness;
            return this;
        }

        public Builder soundEffect(ResourceLocation soundLocation) {
            this.soundEffectLocation = soundLocation;
            return this;
        }

        public Builder initialHover(int start, int end, boolean reverse) {
            if (start != -1 && end != -1) {
                this.initialHoverAnimation = new AnimationFrameRange(start, end, reverse ? AnimationDirection.REVERSE : AnimationDirection.FORWARD);
            }
            return this;
        }

        public Builder hoverLoop(int start, int end, boolean reverse) {
            if (start != -1 && end != -1) {
                this.hoverLoopAnimation = new AnimationFrameRange(start, end, reverse ? AnimationDirection.REVERSE : AnimationDirection.FORWARD);
            }
            return this;
        }

        public Builder mouseOff(int start, int end, boolean reverse) {
            if (start != -1 && end != -1) {
                this.mouseOffAnimation = new AnimationFrameRange(start, end, reverse ? AnimationDirection.REVERSE : AnimationDirection.FORWARD);
            }
            return this;
        }

        public Builder fixedTooltipPosition(boolean fixed) {
            this.fixedTooltipPosition = fixed;
            return this;
        }

        public MapSquareButton build() {
            return new MapSquareButton(this);
        }
    }

    private static class AnimationController {
        private final Builder settings;
        private AnimationState currentState = AnimationState.IDLE;
        private boolean wasHovered = false;
        private long animationStartTime = 0L;

        AnimationController(Builder builder) {
            this.settings = builder;
        }

        public void update(boolean isHovered) {
            if (isHovered && !this.wasHovered) {
                this.startAnimation(AnimationState.HOVER_INITIAL);
            } else if (!isHovered && this.wasHovered) {
                this.startAnimation(AnimationState.MOUSE_OFF);
            }
            this.wasHovered = isHovered;
        }

        private void startAnimation(AnimationState state) {
            this.currentState = state;
            this.animationStartTime = Objects.requireNonNull(Minecraft.getInstance().level).getGameTime();
        }

        public RenderData getRenderData() {
            if (this.settings.animationLocation == null || this.currentState == AnimationState.IDLE) {
                return new RenderData(this.settings.imageLocation, 0, 0, this.settings.tileWidth, this.settings.tileHeight);
            }
            long elapsedTicks = Objects.requireNonNull(Minecraft.getInstance().level).getGameTime() - this.animationStartTime;
            AnimationFrameRange activeRange = this.getActiveRange();
            if (activeRange == null) {
                this.currentState = AnimationState.IDLE;
                return new RenderData(this.settings.imageLocation, 0, 0, this.settings.tileWidth, this.settings.tileHeight);
            }
            int frameCount = activeRange.getFrameCount();
            int frameIndex = (int)elapsedTicks;
            boolean loop = this.isLooping();
            if (!loop && frameIndex >= frameCount) {
                if (this.currentState == AnimationState.HOVER_INITIAL) {
                    this.startAnimation(AnimationState.HOVER_LOOP);
                } else if (this.currentState == AnimationState.MOUSE_OFF) {
                    this.currentState = AnimationState.IDLE;
                }
                frameIndex = frameCount - 1;
            }
            int frameOffset = loop ? frameIndex % frameCount : frameIndex;
            int currentFrame = activeRange.direction == AnimationDirection.REVERSE ? activeRange.startFrame - frameOffset : activeRange.startFrame + frameOffset;
            int vOffset = currentFrame * this.settings.tileHeight;
            return new RenderData(this.settings.animationLocation, 0, vOffset, this.settings.tileWidth, this.settings.totalFrames * this.settings.tileHeight);
        }

        private boolean isLooping() {
            return this.currentState == AnimationState.HOVER_LOOP;
        }

        @Nullable
        private AnimationFrameRange getActiveRange() {
            return switch (this.currentState.ordinal()) {
                case 1 -> this.settings.initialHoverAnimation;
                case 2 -> this.settings.hoverLoopAnimation;
                case 3 -> this.settings.mouseOffAnimation;
                default -> null;
            };
        }

        private static enum AnimationState {
            IDLE,
            HOVER_INITIAL,
            HOVER_LOOP,
            MOUSE_OFF;

        }

        record RenderData(@Nullable ResourceLocation texture, int u, int v, int textureWidth, int textureHeight) {
        }
    }

    private record AnimationFrameRange(int startFrame, int endFrame, AnimationDirection direction) {
        int getFrameCount() {
            return Math.abs(this.endFrame - this.startFrame) + 1;
        }
    }

    private static enum AnimationDirection {
        FORWARD,
        REVERSE;

    }
}

