/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.render;

import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.rasanovum.viaromana.util.PathUtils;

public class RenderUtil {
    @OnlyIn(value=Dist.CLIENT)
    public static double findSuitableYPosition(ClientLevel level, BlockPos pos, float offsetY) {
        return RenderUtil.findSuitableYPosition(level, pos, offsetY, 5, 5);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static double findSuitableYPosition(ClientLevel level, BlockPos pos, float offsetY, int maxUp, int maxDown) {
        if (level.getChunkSource().getChunk(pos.getX() >> 4, pos.getZ() >> 4, false) == null) {
            return (float)pos.getY() + offsetY;
        }
        BlockPos belowSource = pos.below();
        BlockState belowSourceState = level.getBlockState(belowSource);
        VoxelShape belowSourceShape = belowSourceState.getCollisionShape((BlockGetter)level, belowSource, CollisionContext.empty());
        double sourceSurfaceY = belowSourceShape.isEmpty() ? (double)pos.getY() : (double)belowSource.getY() + belowSourceShape.max(Direction.Axis.Y);
        ArrayList<Double> validPositions = new ArrayList<Double>();
        for (int yOffset = -maxDown; yOffset <= maxUp; ++yOffset) {
            BlockPos abovePos;
            BlockState aboveState;
            VoxelShape aboveShape;
            BlockPos checkPos = pos.offset(0, yOffset, 0);
            BlockState checkState = level.getBlockState(checkPos);
            VoxelShape checkShape = checkState.getCollisionShape((BlockGetter)level, checkPos, CollisionContext.empty());
            if (checkShape.isEmpty() && !PathUtils.isBlockValidPath((LevelAccessor)level, checkPos) || !(aboveShape = (aboveState = level.getBlockState(abovePos = checkPos.above())).getCollisionShape((BlockGetter)level, abovePos, CollisionContext.empty())).isEmpty() || PathUtils.isBlockValidPath((LevelAccessor)level, abovePos)) continue;
            double surfaceY = checkShape.isEmpty() ? (double)checkPos.getY() + 1.0 : (double)checkPos.getY() + checkShape.max(Direction.Axis.Y);
            validPositions.add(surfaceY + (double)offsetY);
        }
        if (validPositions.isEmpty()) {
            return sourceSurfaceY + (double)offsetY;
        }
        double biasedTarget = sourceSurfaceY + (double)offsetY + 1.0;
        return validPositions.stream().min(Comparator.comparingDouble(a -> Math.abs(a - biasedTarget))).orElse(sourceSurfaceY + (double)offsetY);
    }
}

