/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.client.gui.MapRenderer;
import net.rasanovum.viaromana.map.ServerMapCache;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.level.LevelDataManager;
import net.rasanovum.viaromana.storage.path.PathDataManager;
import net.rasanovum.viaromana.storage.path.legacy.IPathStorage;
import net.rasanovum.viaromana.storage.player.PlayerData;
import net.rasanovum.viaromana.util.PathSyncUtils;

public class ViaRomanaCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"viaromana").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"nodes").then(Commands.literal((String)"clear").executes(ViaRomanaCommands::clearAllNodes)))).then(Commands.literal((String)"client").then(Commands.literal((String)"clear").executes(ViaRomanaCommands::clearCache)))).then(Commands.literal((String)"convert").then(Commands.literal((String)"legacyPaths").executes(ViaRomanaCommands::convertLegacyPaths)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"maps").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"clear").then(Commands.literal((String)"all").executes(ViaRomanaCommands::clearMaps))).then(Commands.literal((String)"biomePixels").executes(ViaRomanaCommands::clearBiomePixels))).then(Commands.literal((String)"chunkPixels").executes(ViaRomanaCommands::clearChunkPixels)))).then(Commands.literal((String)"regenerate").executes(ViaRomanaCommands::regenerateMaps))).then(Commands.literal((String)"delete").executes(ViaRomanaCommands::deleteMaps))).then(Commands.literal((String)"save").executes(ViaRomanaCommands::saveMaps))));
    }

    private static int clearAllNodes(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        for (Player player : source.getLevel().players()) {
            PlayerData.setChartingPath(player, false);
        }
        PathGraph graph = PathGraph.getInstance(source.getLevel());
        int nodeCount = graph.size();
        graph.removeAllNodes();
        ClientPathData.getInstance().clearData();
        PathSyncUtils.syncPathGraphToAllPlayers(source.getLevel());
        PathDataManager.markDirty(source.getLevel());
        source.sendSuccess(() -> Component.translatable((String)"command.via_romana.nodes_cleared"), true);
        return nodeCount;
    }

    private static int clearCache(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (source.getLevel().isClientSide()) {
            ClientPathData.getInstance().clearData();
        }
        PathSyncUtils.syncPathGraphToPlayer(source.getPlayerOrException());
        source.sendSuccess(() -> Component.translatable((String)"command.via_romana.cache_cleared"), true);
        return 1;
    }

    private static int convertLegacyPaths(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel currentLevel = source.getLevel();
        PathGraph legacyGraph = IPathStorage.get((Level)currentLevel).graph();
        int legacyNodeCount = legacyGraph.size();
        if (legacyNodeCount == 0) {
            source.sendFailure((Component)Component.translatable((String)"command.via_romana.no_legacy_paths"));
            return 0;
        }
        PathGraph currentGraph = PathDataManager.getOrCreatePathGraph(currentLevel);
        if (currentGraph.size() > 0) {
            source.sendFailure((Component)Component.translatable((String)"command.via_romana.dimension_has_nodes"));
            return 0;
        }
        CompoundTag serializedData = legacyGraph.serialize(new CompoundTag());
        if (serializedData.contains("nodes")) {
            ListTag nodeList = serializedData.getList("nodes", 10);
            for (int i = 0; i < nodeList.size(); ++i) {
                CompoundTag nodeTag = nodeList.getCompound(i);
                nodeTag.putFloat("clearance", 0.0f);
            }
        }
        currentGraph.deserialize(serializedData);
        PathDataManager.markDirty(currentLevel);
        PathSyncUtils.syncPathGraphToAllPlayers(currentLevel);
        source.sendSuccess(() -> Component.translatable((String)"command.via_romana.legacy_converted"), true);
        return legacyNodeCount;
    }

    private static int clearMaps(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.sendSuccess(() -> Component.translatable((String)"command.via_romana.clearing_chunk_data"), false);
        LevelDataManager.clearAllPixelBytes(source.getLevel());
        LevelDataManager.clearAllCornerBytes(source.getLevel());
        ServerMapCache.clear();
        ServerMapCache.deleteAllMapsFromDisk();
        if (source.getLevel().isClientSide()) {
            MapRenderer.clearCache();
        }
        source.sendSuccess(() -> Component.translatable((String)"command.via_romana.maps_and_chunks_cleared"), true);
        return 1;
    }

    private static int clearBiomePixels(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.sendSuccess(() -> Component.translatable((String)"command.via_romana.clearing_biome_data"), false);
        LevelDataManager.clearAllCornerBytes(source.getLevel());
        ServerMapCache.clear();
        ServerMapCache.deleteAllMapsFromDisk();
        if (source.getLevel().isClientSide()) {
            MapRenderer.clearCache();
        }
        source.sendSuccess(() -> Component.translatable((String)"command.via_romana.maps_and_biomes_cleared"), true);
        return 1;
    }

    private static int clearChunkPixels(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.sendSuccess(() -> Component.translatable((String)"command.via_romana.clearing_chunk_pixels"), false);
        LevelDataManager.clearAllPixelBytes(source.getLevel());
        ServerMapCache.clear();
        ServerMapCache.deleteAllMapsFromDisk();
        if (source.getLevel().isClientSide()) {
            MapRenderer.clearCache();
        }
        source.sendSuccess(() -> Component.translatable((String)"command.via_romana.maps_and_chunks_cleared"), true);
        return 1;
    }

    private static int regenerateMaps(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.sendSuccess(() -> Component.translatable((String)"command.via_romana.regenerating_chunks"), false);
        ServerMapCache.regenerateAllChunkPixelData();
        ServerMapCache.processAllDirtyNetworks();
        source.sendSuccess(() -> Component.translatable((String)"command.via_romana.maps_regenerated"), true);
        return 1;
    }

    private static int deleteMaps(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerMapCache.clear();
        ServerMapCache.deleteAllMapsFromDisk();
        if (source.getLevel().isClientSide()) {
            MapRenderer.clearCache();
        }
        source.sendSuccess(() -> Component.translatable((String)"command.via_romana.maps_cleared"), true);
        return 1;
    }

    private static int saveMaps(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerMapCache.saveAllToDisk(true);
        source.sendSuccess(() -> Component.translatable((String)"command.via_romana.maps_saved"), true);
        return 1;
    }
}

