/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.core;

import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.client.HudMessageManager;
import net.rasanovum.viaromana.storage.player.PlayerData;
import net.rasanovum.viaromana.util.PathSyncUtils;

public class DimensionHandler {
    public static void preventHopping(LevelAccessor world, Entity entity) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (PlayerData.isChartingPath(player)) {
            HudMessageManager.queueMessage("message.via_romana.cancel_path_dimension");
            PlayerData.resetVariables(player);
        }
    }

    public static void syncPathDataOnDimensionChange(LevelAccessor world, Entity entity) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        PathSyncUtils.syncPathGraphToPlayer(player);
    }

    public static boolean isValid(LevelAccessor world, Entity entity) {
        if (entity == null) {
            return false;
        }
        List<String> invalidDimensions = CommonConfig.invalid_dimensions;
        for (String invalidDimension : invalidDimensions) {
            if (!entity.level().dimension().toString().contains(invalidDimension)) continue;
            HudMessageManager.queueMessage("message.via_romana.invalid_dimension");
            return false;
        }
        return true;
    }
}

