/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.map;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;

public record MapInfo(UUID networkId, byte[] biomePixels, byte[] chunkPixels, int pixelWidth, int pixelHeight, int scaleFactor, int worldMinX, int worldMinZ, int worldMaxX, int worldMaxZ, Long createdAtMs, List<ChunkPos> allowedChunks, List<DestinationResponseS2C.NodeNetworkInfo> networkNodes) {
    public MapInfo {
        networkNodes = networkNodes != null ? new ArrayList<DestinationResponseS2C.NodeNetworkInfo>(networkNodes) : new ArrayList();
        allowedChunks = allowedChunks != null ? new ArrayList<ChunkPos>(allowedChunks) : null;
        biomePixels = biomePixels != null ? (byte[])biomePixels.clone() : null;
        chunkPixels = chunkPixels != null ? (byte[])chunkPixels.clone() : null;
    }

    public static MapInfo request(UUID networkId, BlockPos minBounds, BlockPos maxBounds, List<DestinationResponseS2C.NodeNetworkInfo> networkNodes) {
        return new MapInfo(networkId, null, null, 0, 0, 1, minBounds.getX(), minBounds.getZ(), maxBounds.getX(), maxBounds.getZ(), null, null, networkNodes != null ? new ArrayList<DestinationResponseS2C.NodeNetworkInfo>(networkNodes) : new ArrayList());
    }

    public static MapInfo fromServer(UUID networkId, byte[] biomePixels, byte[] chunkPixels, int pixelWidth, int pixelHeight, int scaleFactor, int worldMinX, int worldMinZ, int worldMaxX, int worldMaxZ, List<ChunkPos> allowedChunks, List<DestinationResponseS2C.NodeNetworkInfo> networkNodes) {
        return new MapInfo(networkId, biomePixels != null ? (byte[])biomePixels.clone() : null, chunkPixels != null ? (byte[])chunkPixels.clone() : null, pixelWidth, pixelHeight, scaleFactor, worldMinX, worldMinZ, worldMaxX, worldMaxZ, System.currentTimeMillis(), allowedChunks != null ? new ArrayList<ChunkPos>(allowedChunks) : null, networkNodes != null ? new ArrayList<DestinationResponseS2C.NodeNetworkInfo>(networkNodes) : new ArrayList());
    }

    public boolean hasImageData() {
        return (this.biomePixels != null || this.chunkPixels != null) && this.pixelWidth > 0 && this.pixelHeight > 0;
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.networkId);
        buffer.writeInt(this.networkNodes.size());
        for (DestinationResponseS2C.NodeNetworkInfo node : this.networkNodes) {
            buffer.writeBlockPos(node.position);
            buffer.writeFloat(node.clearance);
            buffer.writeInt(node.connections.size());
            for (BlockPos connection : node.connections) {
                buffer.writeBlockPos(connection);
            }
        }
        if (this.hasImageData()) {
            buffer.writeBoolean(true);
            if (this.biomePixels != null) {
                buffer.writeBoolean(true);
                buffer.writeInt(this.biomePixels.length);
                buffer.writeBytes(this.biomePixels);
            } else {
                buffer.writeBoolean(false);
            }
            if (this.chunkPixels != null) {
                buffer.writeBoolean(true);
                buffer.writeInt(this.chunkPixels.length);
                buffer.writeBytes(this.chunkPixels);
            } else {
                buffer.writeBoolean(false);
            }
            buffer.writeInt(this.pixelWidth);
            buffer.writeInt(this.pixelHeight);
            buffer.writeInt(this.scaleFactor);
            buffer.writeInt(this.worldMinX);
            buffer.writeInt(this.worldMinZ);
            buffer.writeInt(this.worldMaxX);
            buffer.writeInt(this.worldMaxZ);
            buffer.writeLong(this.createdAtMs != null ? this.createdAtMs : 0L);
        } else {
            buffer.writeBoolean(false);
        }
    }

    public static MapInfo readFromBuffer(FriendlyByteBuf buffer) {
        UUID networkId = buffer.readUUID();
        int nodeCount = buffer.readInt();
        ArrayList<DestinationResponseS2C.NodeNetworkInfo> networkNodes = new ArrayList<DestinationResponseS2C.NodeNetworkInfo>(nodeCount);
        for (int i = 0; i < nodeCount; ++i) {
            BlockPos nodePos = buffer.readBlockPos();
            float clearance = buffer.readFloat();
            int connectionCount = buffer.readInt();
            ArrayList<BlockPos> connections = new ArrayList<BlockPos>(connectionCount);
            for (int j = 0; j < connectionCount; ++j) {
                connections.add(buffer.readBlockPos());
            }
            networkNodes.add(new DestinationResponseS2C.NodeNetworkInfo(nodePos, clearance, connections));
        }
        boolean hasPixelData = buffer.readBoolean();
        byte[] biomePixels = null;
        byte[] chunkPixels = null;
        int pixelWidth = 0;
        int pixelHeight = 0;
        int scaleFactor = 1;
        int worldMinX = 0;
        int worldMinZ = 0;
        int worldMaxX = 0;
        int worldMaxZ = 0;
        Long createdAtMs = null;
        if (hasPixelData) {
            boolean hasChunkPixels;
            boolean hasBiomePixels = buffer.readBoolean();
            if (hasBiomePixels) {
                int biomeLength = buffer.readInt();
                biomePixels = new byte[biomeLength];
                buffer.readBytes(biomePixels);
            }
            if (hasChunkPixels = buffer.readBoolean()) {
                int chunkLength = buffer.readInt();
                chunkPixels = new byte[chunkLength];
                buffer.readBytes(chunkPixels);
            }
            pixelWidth = buffer.readInt();
            pixelHeight = buffer.readInt();
            scaleFactor = buffer.readInt();
            worldMinX = buffer.readInt();
            worldMinZ = buffer.readInt();
            worldMaxX = buffer.readInt();
            worldMaxZ = buffer.readInt();
            long ts = buffer.readLong();
            createdAtMs = ts == 0L ? null : Long.valueOf(ts);
        }
        return new MapInfo(networkId, biomePixels, chunkPixels, pixelWidth, pixelHeight, scaleFactor, worldMinX, worldMinZ, worldMaxX, worldMaxZ, createdAtMs, null, networkNodes);
    }
}

