/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.mixins;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.teleport.ServerTeleportHandler;
import net.rasanovum.viaromana.teleport.TeleportHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public class ServerPlayerMixin {
    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void onPlayerTick(CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)this;
        Level level = player.level();
        if (!player.isAlive() || player.connection == null || !player.connection.isAcceptingMessages()) {
            return;
        }
        boolean isTeleporting = ServerTeleportHandler.isTeleporting(player);
        if (isTeleporting && CommonConfig.enable_teleport_particles) {
            TeleportHelper.effect((LevelAccessor)level, (Entity)player);
        }
    }
}

