/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.mixins.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.rasanovum.viaromana.core.SignInteract;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiPlayerGameMode.class})
public abstract class ClientPlayerInteractionManagerMixin {
    @Shadow
    @Final
    private Minecraft minecraft;
    private boolean signAttackCancelled = false;

    @Inject(method={"startDestroyBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void viaRomana_onAttackBlock(BlockPos pos, Direction direction, CallbackInfoReturnable<Boolean> cir) {
        if (this.minecraft.player != null && this.minecraft.level != null) {
            boolean shouldCancel;
            this.signAttackCancelled = shouldCancel = SignInteract.clicked((LevelAccessor)this.minecraft.level, pos, (Entity)this.minecraft.player);
            if (shouldCancel) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"continueDestroyBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void viaRomana_onContinueDestroyBlock(BlockPos pos, Direction direction, CallbackInfoReturnable<Boolean> cir) {
        if (this.signAttackCancelled) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"stopDestroyBlock"}, at={@At(value="HEAD")})
    private void viaRomana_onStopDestroyBlock(CallbackInfo ci) {
        this.signAttackCancelled = false;
    }
}

