/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.map.ServerMapCache;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.path.PathDataManager;
import net.rasanovum.viaromana.util.PathSyncUtils;
import net.rasanovum.viaromana.util.VersionUtils;

public record ChartedPathC2S(List<Node.NodeData> chartedNodes) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ChartedPathC2S> TYPE = new CustomPacketPayload.Type(VersionUtils.getLocation("via_romana:charted_path_c2s"));
    public static final StreamCodec<FriendlyByteBuf, ChartedPathC2S> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, ChartedPathC2S>(){

        public ChartedPathC2S decode(FriendlyByteBuf buffer) {
            return ChartedPathC2S.decode(buffer);
        }

        public void encode(FriendlyByteBuf buffer, ChartedPathC2S packet) {
            ChartedPathC2S.encode(buffer, packet);
        }
    };

    public ChartedPathC2S(List<Node.NodeData> chartedNodes) {
        this.chartedNodes = chartedNodes != null ? List.copyOf(chartedNodes) : List.of();
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void encode(FriendlyByteBuf buffer, ChartedPathC2S packet) {
        buffer.writeInt(packet.chartedNodes.size());
        for (Node.NodeData nodeData : packet.chartedNodes) {
            buffer.writeBlockPos(nodeData.pos());
            buffer.writeFloat(nodeData.quality());
            buffer.writeFloat(nodeData.clearance());
        }
    }

    public static ChartedPathC2S decode(FriendlyByteBuf buffer) {
        int nodeCount = buffer.readInt();
        ArrayList<Node.NodeData> nodes = new ArrayList<Node.NodeData>(nodeCount);
        for (int i = 0; i < nodeCount; ++i) {
            BlockPos pos = buffer.readBlockPos();
            float quality = buffer.readFloat();
            float clearance = buffer.readFloat();
            nodes.add(new Node.NodeData(pos, quality, clearance));
        }
        return new ChartedPathC2S(nodes);
    }

    public static void handle(PacketContext<ChartedPathC2S> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            ServerLevel level = ctx.sender().serverLevel();
            PathGraph graph = PathGraph.getInstance(level);
            UUID playerUUID = ctx.sender().getUUID();
            List<Node.NodeData> chartingNodes = ((ChartedPathC2S)ctx.message()).chartedNodes();
            if (chartingNodes.isEmpty()) {
                ViaRomana.LOGGER.warn("Received empty charted path from player {}", (Object)ctx.sender().getName().getString());
                return;
            }
            try {
                graph.createConnectedPath(chartingNodes);
                PathDataManager.markDirty(level);
                PathSyncUtils.syncPathGraphToAllPlayers(level);
                ChartedPathC2S.awardAdvancementIfNeeded(ctx.sender());
                UUID pseudoNetworkId = ServerMapCache.getPseudoNetworkId(playerUUID);
                ServerMapCache.invalidatePseudoNetwork(pseudoNetworkId);
                ViaRomana.LOGGER.debug("Created charted path with {} nodes for player {}, cleaned up pseudonetwork {}", (Object)chartingNodes.size(), (Object)ctx.sender().getName().getString(), (Object)pseudoNetworkId);
            }
            catch (Exception e) {
                ViaRomana.LOGGER.error("Failed to create charted path for player {}: {}", (Object)ctx.sender().getName().getString(), (Object)e.getMessage());
            }
        }
    }

    private static void awardAdvancementIfNeeded(ServerPlayer player) {
        try {
            AdvancementProgress advancementProgress;
            ResourceLocation advancementId = VersionUtils.getLocation("via_romana:story/a_strand_type_game");
            AdvancementHolder advancement = player.server.getAdvancements().get(advancementId);
            if (advancement != null && !(advancementProgress = player.getAdvancements().getOrStartProgress(advancement)).isDone()) {
                boolean grantedAny = false;
                for (String criterion : advancementProgress.getRemainingCriteria()) {
                    boolean granted = player.getAdvancements().award(advancement, criterion);
                    if (!granted) continue;
                    grantedAny = true;
                }
                if (grantedAny) {
                    player.getAdvancements().flushDirty(player);
                }
            }
        }
        catch (Exception e) {
            ViaRomana.LOGGER.warn("Failed to award advancement {} to player {}: {}", (Object)"via_romana:story/a_strand_type_game", (Object)player.getName().getString(), (Object)e.getMessage());
        }
    }
}

