/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import commonnetwork.api.Dispatcher;
import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.util.VersionUtils;

public record DestinationRequestC2S(BlockPos sourceSignPos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<DestinationRequestC2S> TYPE = new CustomPacketPayload.Type(VersionUtils.getLocation("viaromana:destination_request_c2s"));
    public static final StreamCodec<FriendlyByteBuf, DestinationRequestC2S> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, DestinationRequestC2S::sourceSignPos, DestinationRequestC2S::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void encode(FriendlyByteBuf buf, DestinationRequestC2S packet) {
        buf.writeBlockPos(packet.sourceSignPos);
    }

    public static DestinationRequestC2S decode(FriendlyByteBuf buf) {
        return new DestinationRequestC2S(buf.readBlockPos());
    }

    public static void handle(PacketContext<DestinationRequestC2S> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            BlockPos signPos;
            ServerLevel level = ctx.sender().serverLevel();
            PathGraph graph = PathGraph.getInstance(level);
            Optional<Node> sourceNodeOpt = graph.getNodeBySignPos(signPos = ((DestinationRequestC2S)ctx.message()).sourceSignPos());
            if (sourceNodeOpt.isEmpty()) {
                ViaRomana.LOGGER.warn("Received destination request for unknown sign at {}", (Object)signPos);
                return;
            }
            Node sourceNode = sourceNodeOpt.get();
            List<Node> destinations = graph.getCachedTeleportDestinationsFor(ctx.sender().getUUID(), sourceNode);
            PathGraph.NetworkCache cache = graph.getNetworkCache(sourceNode);
            List<DestinationResponseS2C.DestinationInfo> destInfos = destinations.stream().map(dest -> {
                double distance = Math.sqrt(sourceNode.getBlockPos().distSqr((Vec3i)dest.getBlockPos()));
                return new DestinationResponseS2C.DestinationInfo(dest.getBlockPos(), dest.getDestinationName().orElse("Unknown"), distance, dest.getDestinationIcon().orElse(Node.Icon.SIGNPOST));
            }).toList();
            List<DestinationResponseS2C.NodeNetworkInfo> networkInfos = graph.getNodesAsInfo(cache);
            DestinationResponseS2C response = new DestinationResponseS2C(destInfos, signPos, sourceNode.getBlockPos(), networkInfos, cache.id());
            Dispatcher.sendToClient((Object)response, (ServerPlayer)ctx.sender());
        }
    }
}

