/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.core.LinkHandler;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.util.VersionUtils;

public record SignLinkRequestC2S(LinkHandler.LinkData linkData, boolean isTempNode) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SignLinkRequestC2S> TYPE = new CustomPacketPayload.Type(VersionUtils.getLocation("via_romana:link_sign_request"));
    public static final StreamCodec<FriendlyByteBuf, SignLinkRequestC2S> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, SignLinkRequestC2S>(){

        public SignLinkRequestC2S decode(FriendlyByteBuf buffer) {
            BlockPos nodePos = buffer.readBlockPos();
            BlockPos signPos = buffer.readBlockPos();
            Node.LinkType linkType = (Node.LinkType)buffer.readEnum(Node.LinkType.class);
            UUID owner = buffer.readBoolean() ? buffer.readUUID() : null;
            String destinationName = buffer.readUtf();
            Node.Icon icon = (Node.Icon)buffer.readEnum(Node.Icon.class);
            LinkHandler.LinkData linkData = new LinkHandler.LinkData(signPos, nodePos, linkType, icon, destinationName, owner);
            boolean isTempNode = buffer.readBoolean();
            return new SignLinkRequestC2S(linkData, isTempNode);
        }

        public void encode(FriendlyByteBuf buffer, SignLinkRequestC2S packet) {
            buffer.writeBlockPos(packet.linkData.nodePos());
            buffer.writeBlockPos(packet.linkData.signPos());
            buffer.writeEnum((Enum)packet.linkData.linkType());
            buffer.writeBoolean(packet.linkData.owner() != null);
            if (packet.linkData.owner() != null) {
                buffer.writeUUID(packet.linkData.owner());
            }
            buffer.writeUtf(packet.linkData.destinationName());
            buffer.writeEnum((Enum)packet.linkData.icon());
            buffer.writeBoolean(packet.isTempNode);
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void encode(FriendlyByteBuf buf, SignLinkRequestC2S packet) {
        buf.writeBlockPos(packet.linkData.nodePos());
        buf.writeBlockPos(packet.linkData.signPos());
        buf.writeEnum((Enum)packet.linkData.linkType());
        buf.writeBoolean(packet.linkData.owner() != null);
        if (packet.linkData.owner() != null) {
            buf.writeUUID(packet.linkData.owner());
        }
        buf.writeUtf(packet.linkData.destinationName());
        buf.writeEnum((Enum)packet.linkData.icon());
        buf.writeBoolean(packet.isTempNode);
    }

    public static SignLinkRequestC2S decode(FriendlyByteBuf buf) {
        BlockPos nodePos = buf.readBlockPos();
        BlockPos signPos = buf.readBlockPos();
        Node.LinkType linkType = (Node.LinkType)buf.readEnum(Node.LinkType.class);
        UUID owner = buf.readBoolean() ? buf.readUUID() : null;
        String destinationName = buf.readUtf();
        Node.Icon icon = (Node.Icon)buf.readEnum(Node.Icon.class);
        LinkHandler.LinkData linkData = new LinkHandler.LinkData(signPos, nodePos, linkType, icon, destinationName, owner);
        boolean isTempNode = buf.readBoolean();
        return new SignLinkRequestC2S(linkData, isTempNode);
    }

    public static void handle(PacketContext<SignLinkRequestC2S> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            LinkHandler.LinkData linkData;
            ServerLevel level = ctx.sender().serverLevel();
            boolean success = LinkHandler.linkSignToNode(level, linkData = ((SignLinkRequestC2S)ctx.message()).linkData());
            if (!success) {
                ViaRomana.LOGGER.warn("Failed to link sign at {} to node at {} for player {}", (Object)linkData.signPos(), (Object)linkData.nodePos(), (Object)ctx.sender().getName().getString());
            } else {
                ViaRomana.LOGGER.debug("Successfully linked sign at {} to node at {} for player {}", (Object)linkData.signPos(), (Object)linkData.nodePos(), (Object)ctx.sender().getName().getString());
            }
        }
    }
}

