/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.rasanovum.viaromana.teleport.ServerTeleportHandler;
import net.rasanovum.viaromana.util.VersionUtils;

public record TeleportRequestC2S(BlockPos originSignPos, BlockPos destinationPos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TeleportRequestC2S> TYPE = new CustomPacketPayload.Type(VersionUtils.getLocation("viaromana:teleport_request_c2s"));
    public static final StreamCodec<FriendlyByteBuf, TeleportRequestC2S> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, TeleportRequestC2S::originSignPos, (StreamCodec)BlockPos.STREAM_CODEC, TeleportRequestC2S::destinationPos, TeleportRequestC2S::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void encode(FriendlyByteBuf buf, TeleportRequestC2S packet) {
        buf.writeBlockPos(packet.originSignPos);
        buf.writeBlockPos(packet.destinationPos);
    }

    public static TeleportRequestC2S decode(FriendlyByteBuf buf) {
        BlockPos origin = buf.readBlockPos();
        BlockPos destination = buf.readBlockPos();
        return new TeleportRequestC2S(origin, destination);
    }

    public static void handle(PacketContext<TeleportRequestC2S> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            ServerTeleportHandler.handleTeleportRequest((TeleportRequestC2S)ctx.message(), ctx.sender());
        }
    }
}

