/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.path;

import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ChunkPos;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.map.ServerMapCache;
import net.rasanovum.viaromana.map.ServerMapUtils;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.storage.path.PathDataManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathGraph {
    private final ObjectArrayList<Node> nodes = new ObjectArrayList();
    private final Long2IntOpenHashMap posToIndex = new Long2IntOpenHashMap();
    private final Long2IntOpenHashMap signPosToIndex = new Long2IntOpenHashMap();
    private final ConcurrentMap<UUID, NetworkCache> networkCacheById = new ConcurrentHashMap<UUID, NetworkCache>();
    private final Long2ObjectOpenHashMap<UUID> nodeToNetworkId = new Long2ObjectOpenHashMap();
    private final ConcurrentMap<UUID, FoWCache> fowCacheById = new ConcurrentHashMap<UUID, FoWCache>();
    private static final DyeColor[] NETWORK_COLORS = new DyeColor[]{DyeColor.BLUE, DyeColor.RED, DyeColor.GREEN, DyeColor.PURPLE, DyeColor.CYAN, DyeColor.ORANGE, DyeColor.LIME, DyeColor.PINK, DyeColor.MAGENTA, DyeColor.YELLOW};

    public static PathGraph getInstance(ServerLevel level) {
        return PathDataManager.getOrCreatePathGraph(level);
    }

    @NotNull
    private NetworkCache getNetworkCacheForNode(Node startNode) {
        NetworkCache cached;
        UUID networkId = (UUID)this.nodeToNetworkId.get(startNode.getPos());
        if (networkId != null && (cached = (NetworkCache)this.networkCacheById.get(networkId)) != null) {
            return cached;
        }
        return this.discoverAndCacheNetwork(startNode);
    }

    private NetworkCache discoverAndCacheNetwork(Node startNode) {
        List<Node> networkNodes = this.getNetwork(startNode);
        Set<Long> positions = networkNodes.stream().map(Node::getPos).collect(Collectors.toSet());
        UUID networkId = this.generateDeterministicUUID(positions);
        NetworkCache existingCache = (NetworkCache)this.networkCacheById.get(networkId);
        if (existingCache != null) {
            this.nodeToNetworkId.put(startNode.getPos(), (Object)networkId);
            return existingCache;
        }
        BoundingBox bounds = this.calculateBoundsFor(networkNodes);
        List<Node> destinations = networkNodes.stream().filter(n -> n.getLinkType() == Node.LinkType.DESTINATION || n.getLinkType() == Node.LinkType.PRIVATE).toList();
        NetworkCache newCache = new NetworkCache(networkId, positions, bounds, destinations);
        this.networkCacheById.put(networkId, newCache);
        for (Long pos : positions) {
            this.nodeToNetworkId.put(pos, (Object)networkId);
        }
        this.fowCacheById.remove(networkId);
        return newCache;
    }

    private Set<NetworkCache> invalidateNetworksContaining(Node ... nodesToInvalidate) {
        HashSet<NetworkCache> invalidatedCaches = new HashSet<NetworkCache>();
        for (Node node : nodesToInvalidate) {
            List<Node> component = this.getNetwork(node);
            if (component.isEmpty()) continue;
            Set<Long> positions = component.stream().map(Node::getPos).collect(Collectors.toSet());
            UUID componentId = this.generateDeterministicUUID(positions);
            NetworkCache removedCache = (NetworkCache)this.networkCacheById.remove(componentId);
            if (removedCache != null) {
                invalidatedCaches.add(removedCache);
            }
            this.fowCacheById.remove(componentId);
            for (Node n : component) {
                this.nodeToNetworkId.remove(n.getPos());
            }
            try {
                ServerMapCache.invalidate(componentId);
            }
            catch (Exception e) {
                ViaRomana.LOGGER.warn("Failed to invalidate ServerMapCache for network {}: {}", (Object)componentId, (Object)e.getMessage());
            }
        }
        return invalidatedCaches;
    }

    private void refreshNetworkDestinations(Node startNode) {
        NetworkCache existing = this.getNetworkCacheForNode(startNode);
        List<Node> destinations = this.getNetwork(startNode).stream().filter(n -> n.getLinkType() == Node.LinkType.DESTINATION || n.getLinkType() == Node.LinkType.PRIVATE).toList();
        NetworkCache updated = new NetworkCache(existing.id(), existing.nodePositions(), existing.bounds(), destinations);
        this.networkCacheById.put(updated.id(), updated);
    }

    private UUID generateDeterministicUUID(Set<Long> nodePositions) {
        if (nodePositions.isEmpty()) {
            return UUID.randomUUID();
        }
        long[] sortedPositions = nodePositions.stream().mapToLong(l -> l).sorted().toArray();
        ByteBuffer bb = ByteBuffer.allocate(sortedPositions.length * 8);
        for (long pos : sortedPositions) {
            bb.putLong(pos);
        }
        return UUID.nameUUIDFromBytes(bb.array());
    }

    public DyeColor getNetworkColor(Node node) {
        NetworkCache cache = this.getNetworkCacheForNode(node);
        int colorIndex = Math.abs(cache.id().hashCode() % NETWORK_COLORS.length);
        return NETWORK_COLORS[colorIndex];
    }

    public List<Node> nodesView() {
        return Collections.unmodifiableList(this.nodes);
    }

    public int size() {
        return this.nodes.size();
    }

    public boolean contains(BlockPos pos) {
        return this.posToIndex.containsKey(pos.asLong());
    }

    public Optional<Node> getNodeAt(BlockPos pos) {
        int idx = this.posToIndex.getOrDefault(pos.asLong(), -1);
        return idx != -1 ? Optional.of((Node)this.nodes.get(idx)) : Optional.empty();
    }

    public int getOrCreateNode(BlockPos pos, float quality, float clearance) {
        return this.posToIndex.computeIfAbsent(pos.asLong(), nodePos -> {
            int newIndex = this.nodes.size();
            this.nodes.add((Object)new Node(nodePos, quality, clearance));
            return newIndex;
        });
    }

    /*
     * WARNING - void declaration
     */
    public void createConnectedPath(List<Node.NodeData> pathData) {
        void var4_8;
        if (pathData == null || pathData.size() < 2) {
            return;
        }
        ArrayList<Node> pathNodes = new ArrayList<Node>();
        for (Node.NodeData nodeData : pathData) {
            Node currentNode = (Node)this.nodes.get(this.getOrCreateNode(nodeData.pos(), nodeData.quality(), nodeData.clearance()));
            pathNodes.add(currentNode);
        }
        HashSet<UUID> networksToInvalidate = new HashSet<UUID>();
        for (Node node : pathNodes) {
            UUID networkId = (UUID)this.nodeToNetworkId.get(node.getPos());
            if (networkId == null) continue;
            networksToInvalidate.add(networkId);
        }
        for (UUID networkId : networksToInvalidate) {
            NetworkCache cache = (NetworkCache)this.networkCacheById.remove(networkId);
            if (cache == null) continue;
            this.fowCacheById.remove(networkId);
            for (Long pos : cache.nodePositions()) {
                this.nodeToNetworkId.remove(pos.longValue());
            }
            try {
                ServerMapCache.invalidate(networkId);
            }
            catch (Exception e) {
                ViaRomana.LOGGER.warn("Failed to invalidate ServerMapCache for network {}: {}", (Object)networkId, (Object)e.getMessage());
            }
        }
        boolean bl = true;
        while (var4_8 < pathNodes.size()) {
            ((Node)pathNodes.get((int)(var4_8 - true))).connect((Node)pathNodes.get((int)var4_8));
            ++var4_8;
        }
    }

    public void createOrUpdatePseudoNetwork(UUID pseudoNetworkId, List<Node.NodeData> tempNodes) {
        if (tempNodes == null || tempNodes.size() < 2) {
            return;
        }
        NetworkCache existing = (NetworkCache)this.networkCacheById.remove(pseudoNetworkId);
        if (existing != null) {
            for (long pos : existing.nodePositions) {
                this.nodeToNetworkId.remove(pos);
            }
            this.fowCacheById.remove(pseudoNetworkId);
        }
        Set<Long> nodePositions = tempNodes.stream().map(nodeData -> nodeData.pos().asLong()).collect(Collectors.toSet());
        List posList = tempNodes.stream().map(Node.NodeData::pos).collect(Collectors.toList());
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlockPos pos : posList) {
            minX = Math.min(minX, pos.getX());
            minY = Math.min(minY, pos.getY());
            minZ = Math.min(minZ, pos.getZ());
            maxX = Math.max(maxX, pos.getX());
            maxY = Math.max(maxY, pos.getY());
            maxZ = Math.max(maxZ, pos.getZ());
        }
        BoundingBox bounds = new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
        NetworkCache pseudoCache = new NetworkCache(pseudoNetworkId, nodePositions, bounds, List.of());
        this.networkCacheById.put(pseudoNetworkId, pseudoCache);
        for (long pos : nodePositions) {
            this.nodeToNetworkId.put(pos, (Object)pseudoNetworkId);
        }
        ViaRomana.LOGGER.debug("Created/updated pseudonetwork {} with {} nodes", (Object)pseudoNetworkId, (Object)tempNodes.size());
    }

    public void removeNode(Node node) {
        this.removeNode(node.getBlockPos());
    }

    public void removeNode(BlockPos pos) {
        long packedPos = pos.asLong();
        int idx = this.posToIndex.getOrDefault(packedPos, -1);
        if (idx == -1) {
            return;
        }
        Node removedNode = (Node)this.nodes.get(idx);
        this.invalidateNetworksContaining(removedNode);
        LongIterator longIterator = removedNode.getConnectedNodes().iterator();
        while (longIterator.hasNext()) {
            long neighborPos = (Long)longIterator.next();
            this.getNodeAt(BlockPos.of((long)neighborPos)).ifPresent(neighbor -> neighbor.removeConnection(packedPos));
        }
        int lastIdx = this.nodes.size() - 1;
        Node lastNode = (Node)this.nodes.get(lastIdx);
        this.nodes.set(idx, (Object)lastNode);
        this.nodes.remove(lastIdx);
        this.posToIndex.remove(packedPos);
        removedNode.getSignPos().ifPresent(signPos -> this.signPosToIndex.remove(signPos.longValue()));
        if (idx < lastIdx) {
            this.posToIndex.put(lastNode.getPos(), idx);
            lastNode.getSignPos().ifPresent(signPos -> this.signPosToIndex.put(signPos.longValue(), idx));
        }
    }

    public Optional<NetworkCache> removeBranch(Node startNode) {
        Set<Node> branchNodes = this.findBranchNodes(startNode);
        if (branchNodes.isEmpty()) {
            return Optional.empty();
        }
        Set<NetworkCache> invalidatedCaches = this.invalidateNetworksContaining(startNode);
        Set branchPositions = branchNodes.stream().map(Node::getPos).collect(Collectors.toSet());
        for (Node node : branchNodes) {
            LongIterator longIterator = node.getConnectedNodes().iterator();
            while (longIterator.hasNext()) {
                long neighborPos = (Long)longIterator.next();
                if (branchPositions.contains(neighborPos)) continue;
                this.getNodeAt(BlockPos.of((long)neighborPos)).ifPresent(neighbor -> neighbor.removeConnection(node.getPos()));
            }
            this.removeNodeWithoutNeighborUpdates(node);
        }
        return invalidatedCaches.stream().findFirst();
    }

    private void removeNodeWithoutNeighborUpdates(Node node) {
        long packedPos = node.getPos();
        int idx = this.posToIndex.getOrDefault(packedPos, -1);
        if (idx == -1) {
            return;
        }
        int lastIdx = this.nodes.size() - 1;
        Node lastNode = (Node)this.nodes.get(lastIdx);
        this.nodes.set(idx, (Object)lastNode);
        this.nodes.remove(lastIdx);
        this.posToIndex.remove(packedPos);
        node.getSignPos().ifPresent(signPos -> this.signPosToIndex.remove(signPos.longValue()));
        if (idx < lastIdx) {
            this.posToIndex.put(lastNode.getPos(), idx);
            lastNode.getSignPos().ifPresent(signPos -> this.signPosToIndex.put(signPos.longValue(), idx));
        }
    }

    public void removeAndHealConnections(Node node) {
        long[] neighbors = node.getConnectedNodes().toLongArray();
        this.invalidateNetworksContaining(node);
        for (long neighborPos : neighbors) {
            this.getNodeAt(BlockPos.of((long)neighborPos)).ifPresent(neighbor -> neighbor.removeConnection(node.getPos()));
        }
        if (neighbors.length == 2) {
            Optional<Node> nodeA = this.getNodeAt(BlockPos.of((long)neighbors[0]));
            Optional<Node> nodeB = this.getNodeAt(BlockPos.of((long)neighbors[1]));
            if (nodeA.isPresent() && nodeB.isPresent()) {
                nodeA.get().connect(nodeB.get());
            }
        }
        this.removeNodeWithoutNeighborUpdates(node);
    }

    public void removeAllNodes() {
        for (NetworkCache cache : this.networkCacheById.values()) {
            try {
                ServerMapCache.invalidate(cache.id());
            }
            catch (Exception e) {
                ViaRomana.LOGGER.warn("Failed to invalidate ServerMapCache during clear for {}: {}", (Object)cache.id(), (Object)e.getMessage());
            }
        }
        this.nodes.clear();
        this.posToIndex.clear();
        this.signPosToIndex.clear();
        this.networkCacheById.clear();
        this.nodeToNetworkId.clear();
        this.fowCacheById.clear();
    }

    public boolean linkSignToNode(BlockPos nodePos, BlockPos signPos, Node.LinkType linkType, UUID owner) {
        return this.getNodeAt(nodePos).map(node -> {
            node.setSignPos(signPos.asLong());
            node.setLinkType(linkType);
            if (linkType == Node.LinkType.PRIVATE && owner != null) {
                node.setPrivateOwner(owner);
            }
            this.signPosToIndex.put(signPos.asLong(), this.posToIndex.get(nodePos.asLong()));
            this.refreshNetworkDestinations((Node)node);
            return true;
        }).orElse(false);
    }

    public boolean removeSignLink(BlockPos signPos) {
        return this.getNodeBySignPos(signPos).map(node -> {
            node.unlink();
            this.signPosToIndex.remove(signPos.asLong());
            this.refreshNetworkDestinations((Node)node);
            return true;
        }).orElse(false);
    }

    public Optional<Node> getNodeBySignPos(BlockPos signPos) {
        int idx = this.signPosToIndex.getOrDefault(signPos.asLong(), -1);
        return idx != -1 ? Optional.of((Node)this.nodes.get(idx)) : Optional.empty();
    }

    public Optional<Node> getNearestNode(BlockPos origin, double maxDistance, Predicate<Node> filter) {
        return this.getNearestNode(origin, maxDistance, maxDistance, filter);
    }

    public Optional<Node> getNearestNode(BlockPos origin, double maxDistance, double maxYDistance, Predicate<Node> filter) {
        return this.nodes.stream().filter(filter).filter(node -> ClientPathData.calculateDistance(node.getBlockPos(), origin, false) <= maxDistance * maxDistance && (double)Math.abs(node.getBlockPos().getY() - origin.getY()) <= maxYDistance).min(Comparator.comparingDouble(node -> ClientPathData.calculateDistance(node.getBlockPos(), origin, true)));
    }

    public List<Node> getNetwork(Node start) {
        ArrayList<Node> network = new ArrayList<Node>();
        HashSet<Long> visited = new HashSet<Long>();
        ArrayDeque<Node> queue = new ArrayDeque<Node>();
        visited.add(start.getPos());
        queue.add(start);
        while (!queue.isEmpty()) {
            Node current = (Node)queue.poll();
            network.add(current);
            LongIterator longIterator = current.getConnectedNodes().iterator();
            while (longIterator.hasNext()) {
                long neighborPos = (Long)longIterator.next();
                if (!visited.add(neighborPos)) continue;
                this.getNodeAt(BlockPos.of((long)neighborPos)).ifPresent(queue::add);
            }
        }
        return network;
    }

    private Set<Node> findBranchNodes(Node start) {
        HashSet<Node> branch = new HashSet<Node>();
        if (start.getConnectedNodes().size() >= 3) {
            branch.add(start);
            return branch;
        }
        ArrayDeque<Node> queue = new ArrayDeque<Node>();
        HashSet<Node> visited = new HashSet<Node>();
        queue.add(start);
        visited.add(start);
        while (!queue.isEmpty()) {
            Node current = (Node)queue.poll();
            branch.add(current);
            LongIterator longIterator = current.getConnectedNodes().iterator();
            while (longIterator.hasNext()) {
                long neighborPos = (Long)longIterator.next();
                this.getNodeAt(BlockPos.of((long)neighborPos)).ifPresent(neighbor -> {
                    if (visited.add((Node)neighbor) && neighbor.getConnectedNodes().size() < 3) {
                        queue.add((Node)neighbor);
                    }
                });
            }
        }
        return branch;
    }

    public BoundingBox getNetworkBounds(Node sourceNode) {
        return this.getNetworkCacheForNode(sourceNode).bounds();
    }

    public List<Node> getCachedTeleportDestinationsFor(UUID playerId, Node sourceNode) {
        NetworkCache cache = this.getNetworkCacheForNode(sourceNode);
        return cache.destinationNodes().stream().filter(node -> node.getPos() != sourceNode.getPos()).filter(node -> node.isAccessibleBy(playerId)).toList();
    }

    private BoundingBox calculateBoundsFor(List<Node> networkNodes) {
        if (networkNodes.isEmpty()) {
            return BoundingBox.ZERO;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (Node node : networkNodes) {
            BlockPos pos = node.getBlockPos();
            minX = Math.min(minX, pos.getX());
            minY = Math.min(minY, pos.getY());
            minZ = Math.min(minZ, pos.getZ());
            maxX = Math.max(maxX, pos.getX());
            maxY = Math.max(maxY, pos.getY());
            maxZ = Math.max(maxZ, pos.getZ());
        }
        return new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Nullable
    public NetworkCache getNetworkCache(UUID id) {
        return (NetworkCache)this.networkCacheById.get(id);
    }

    public NetworkCache getNetworkCache(Node startNode) {
        return this.getNetworkCacheForNode(startNode);
    }

    public List<NetworkCache> findNetworksForChunk(ChunkPos chunkPos) {
        HashSet<UUID> seen = new HashSet<UUID>();
        ArrayList<NetworkCache> result = new ArrayList<NetworkCache>();
        for (Node node : this.nodes) {
            NetworkCache cache = this.getNetworkCacheForNode(node);
            if (!seen.add(cache.id())) continue;
            FoWCache fow = this.getOrComputeFoWCache(cache);
            if (chunkPos.x < fow.minChunk().x || chunkPos.x > fow.maxChunk().x || chunkPos.z < fow.minChunk().z || chunkPos.z > fow.maxChunk().z || !fow.allowedChunks().contains(chunkPos)) continue;
            result.add(cache);
        }
        return result;
    }

    public FoWCache getOrComputeFoWCache(NetworkCache network) {
        boolean isPseudo = ServerMapCache.isPseudoNetwork(network.id());
        return this.fowCacheById.computeIfAbsent(network.id(), id -> PathGraph.calculateFoWData(network.nodePositions(), isPseudo));
    }

    public static FoWCache calculateFoWData(Set<Long> nodeLongs, boolean isPseudo) {
        if (nodeLongs.isEmpty()) {
            return null;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (Long nodeLong : nodeLongs) {
            int x = BlockPos.getX((long)nodeLong);
            int y = BlockPos.getY((long)nodeLong);
            int z = BlockPos.getZ((long)nodeLong);
            minX = Math.min(minX, x);
            minY = Math.min(minY, y);
            minZ = Math.min(minZ, z);
            maxX = Math.max(maxX, x);
            maxY = Math.max(maxY, y);
            maxZ = Math.max(maxZ, z);
        }
        int cacheWidth = maxX - minX;
        int cacheHeight = maxZ - minZ;
        int padding = ServerMapUtils.calculateUniformPadding(cacheWidth, cacheHeight);
        BlockPos paddedMin = new BlockPos(minX - padding, minY, minZ - padding);
        BlockPos paddedMax = new BlockPos(maxX + padding, maxY, maxZ + padding);
        ChunkPos minChunk = new ChunkPos(paddedMin);
        ChunkPos maxChunk = new ChunkPos(paddedMax);
        Set<ChunkPos> allowedChunks = ServerMapUtils.calculateFogOfWarChunks(nodeLongs, minChunk, maxChunk, isPseudo);
        return new FoWCache(minChunk, maxChunk, paddedMin, paddedMax, allowedChunks);
    }

    public List<Node> queryNearby(BlockPos center, double radius) {
        double radiusSquared = radius * radius;
        return this.nodes.stream().filter(node -> node.getBlockPos().distSqr((Vec3i)center) <= radiusSquared).collect(Collectors.toList());
    }

    public CompoundTag serialize(CompoundTag root) {
        ListTag list = new ListTag();
        for (Node node : this.nodes) {
            list.add((Object)node.serialize(new CompoundTag()));
        }
        root.put("nodes", (Tag)list);
        return root;
    }

    public void deserialize(CompoundTag root) {
        this.removeAllNodes();
        ListTag list = root.getList("nodes", 10);
        for (Tag raw : list) {
            CompoundTag nodeTag = (CompoundTag)raw;
            long pos = nodeTag.getLong("pos");
            if (pos == BlockPos.ZERO.asLong()) continue;
            this.nodes.add((Object)new Node(nodeTag));
        }
        this.rebuildIndices();
    }

    public void rebuildIndices() {
        this.posToIndex.clear();
        this.signPosToIndex.clear();
        int i = 0;
        while (i < this.nodes.size()) {
            Node node = (Node)this.nodes.get(i);
            this.posToIndex.put(node.getPos(), i);
            int finalI = i++;
            node.getSignPos().ifPresent(sp -> this.signPosToIndex.put(sp.longValue(), finalI));
        }
    }

    public List<DestinationResponseS2C.NodeNetworkInfo> getNodesAsInfo(NetworkCache cache) {
        return cache.getNodesAsInfo(this.posToIndex, this.nodes);
    }

    public record NetworkCache(UUID id, Set<Long> nodePositions, BoundingBox bounds, List<Node> destinationNodes) {
        public BlockPos getMin() {
            return new BlockPos(this.bounds.minX, this.bounds.minY, this.bounds.minZ);
        }

        public BlockPos getMax() {
            return new BlockPos(this.bounds.maxX, this.bounds.maxY, this.bounds.maxZ);
        }

        public List<DestinationResponseS2C.NodeNetworkInfo> getNodesAsInfo(Long2IntOpenHashMap posToIndex, ObjectArrayList<Node> allNodes) {
            return this.nodePositions.stream().map(pos -> {
                if (posToIndex.containsKey(pos)) {
                    int index = posToIndex.get(pos);
                    Node node = (Node)allNodes.get(index);
                    List<BlockPos> connections = node.getConnectedNodes().longStream().mapToObj(BlockPos::of).collect(Collectors.toList());
                    return new DestinationResponseS2C.NodeNetworkInfo(BlockPos.of((long)pos), node.getClearance(), connections);
                }
                return new DestinationResponseS2C.NodeNetworkInfo(BlockPos.of((long)pos), 0.0f, List.of());
            }).collect(Collectors.toList());
        }
    }

    public record BoundingBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        public static final BoundingBox ZERO = new BoundingBox(0, 0, 0, 0, 0, 0);
    }

    public record FoWCache(ChunkPos minChunk, ChunkPos maxChunk, BlockPos minBlock, BlockPos maxBlock, Set<ChunkPos> allowedChunks) {
    }
}

