/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.gui.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1041;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_4264;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public class MapSquareButton
extends class_4264 {
    private final Consumer<MapSquareButton> onPress;
    private final AnimationController animationController;
    private final boolean fixedTooltipPosition;
    private final float hoverBrightness;
    private final float clickBrightness;
    private boolean isPressed = false;
    @Nullable
    private class_2960 soundEffectLocation;
    private class_2561 tooltipComponent;
    @Nullable
    private class_2561 disabledTooltipComponent;
    private boolean frozen = false;

    private MapSquareButton(Builder builder) {
        super(builder.x, builder.y, builder.width, builder.height, builder.message);
        this.onPress = builder.onPress;
        this.tooltipComponent = builder.tooltip;
        this.disabledTooltipComponent = builder.disabledTooltip;
        this.fixedTooltipPosition = builder.fixedTooltipPosition;
        this.animationController = new AnimationController(builder);
        this.hoverBrightness = builder.hoverBrightness;
        this.clickBrightness = builder.clickBrightness;
        this.soundEffectLocation = builder.soundEffectLocation;
        this.updateTooltip();
    }

    public void setDisabled(boolean disabled) {
        this.field_22763 = !disabled;
        this.updateTooltip();
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
        this.updateTooltip();
    }

    public void setTooltip(class_2561 tooltip) {
        this.tooltipComponent = tooltip;
        this.updateTooltip();
    }

    public void setTooltips(class_2561 tooltip, @Nullable class_2561 disabledTooltip) {
        this.tooltipComponent = tooltip;
        this.disabledTooltipComponent = disabledTooltip;
        this.updateTooltip();
    }

    public void method_25306() {
        if (this.field_22763 && !this.frozen && this.onPress != null) {
            this.onPress.accept(this);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.frozen) {
            return false;
        }
        boolean result = super.method_25402(mouseX, mouseY, button);
        if (result) {
            this.isPressed = true;
        }
        return result;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.frozen) {
            return false;
        }
        boolean result = super.method_25406(mouseX, mouseY, button);
        this.isPressed = false;
        return result;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.frozen) {
            return false;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    protected boolean method_25351(int button) {
        if (this.frozen) {
            return false;
        }
        return super.method_25351(button);
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.field_22764) {
            return;
        }
        if (!this.frozen) {
            this.animationController.update(this.method_49606());
        }
        this.renderButtonImage(guiGraphics);
        this.renderButtonText(guiGraphics);
        if (!this.frozen) {
            this.renderFixedTooltip(guiGraphics);
        }
    }

    protected void method_47399(class_6382 narrationElementOutput) {
        this.method_37021(narrationElementOutput);
    }

    public void method_25348(double mouseX, double mouseY) {
        this.method_25354(class_310.method_1551().method_1483());
        super.method_25348(mouseX, mouseY);
    }

    public void method_25354(class_1144 soundManager) {
        if (this.soundEffectLocation != null) {
            class_3414 soundEvent = class_3414.method_47908((class_2960)this.soundEffectLocation);
            soundManager.method_4873((class_1113)class_1109.method_4758((class_3414)soundEvent, (float)1.0f));
        } else {
            super.method_25354(soundManager);
        }
    }

    private void renderButtonImage(class_332 guiGraphics) {
        AnimationController.RenderData data = this.animationController.getRenderData();
        if (data.texture == null) {
            return;
        }
        int imageSize = Math.min(this.field_22758, this.field_22759);
        int imageX = this.method_46426() + (this.field_22758 - imageSize) / 2;
        int imageY = this.method_46427() + (this.field_22759 - imageSize) / 2;
        if (!this.field_22763) {
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
        } else {
            float multiplier = 1.0f;
            if (this.isPressed) {
                multiplier = this.clickBrightness;
            } else if (this.method_49606()) {
                multiplier = this.hoverBrightness;
            }
            RenderSystem.setShaderColor((float)multiplier, (float)multiplier, (float)multiplier, (float)1.0f);
        }
        guiGraphics.method_25290(data.texture, imageX, imageY, (float)data.u, (float)data.v, imageSize, imageSize, data.textureWidth, data.textureHeight);
        if (!this.field_22763) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderButtonText(class_332 guiGraphics) {
        class_327 font = class_310.method_1551().field_1772;
        int textX = this.method_46426() + (this.field_22758 - font.method_27525((class_5348)this.method_25369())) / 2;
        int n = this.method_46427() + this.field_22759;
        Objects.requireNonNull(font);
        int textY = n - 9 - 2;
        int textColor = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
        int strokeColor = this.field_22763 ? 0 : 0x404040;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                if (dx == 0 && dy == 0) continue;
                guiGraphics.method_51439(font, this.method_25369(), textX + dx, textY + dy, strokeColor, false);
            }
        }
        guiGraphics.method_51439(font, this.method_25369(), textX, textY, textColor, false);
    }

    private void renderFixedTooltip(class_332 guiGraphics) {
        class_2561 currentTooltip;
        if (this.method_49606() && this.fixedTooltipPosition && (currentTooltip = this.getActiveTooltip()) != null) {
            class_1041 window = class_310.method_1551().method_22683();
            int screenWidth = window.method_4486();
            int screenHeight = window.method_4502();
            int textWidth = class_310.method_1551().field_1772.method_27525((class_5348)currentTooltip);
            int x = (screenWidth - textWidth) / 2 - 12;
            int y = screenHeight - ((screenHeight - 256) / 2 + 30) / 2 + 7;
            guiGraphics.method_51438(class_310.method_1551().field_1772, currentTooltip, x, y);
        }
    }

    private void updateTooltip() {
        if (!this.fixedTooltipPosition) {
            if (this.frozen) {
                super.method_47400(null);
            } else {
                class_2561 currentTooltip = this.getActiveTooltip();
                super.method_47400(currentTooltip != null ? class_7919.method_47407((class_2561)currentTooltip) : null);
            }
        }
    }

    @Nullable
    private class_2561 getActiveTooltip() {
        return !this.field_22763 && this.disabledTooltipComponent != null ? this.disabledTooltipComponent : this.tooltipComponent;
    }

    public static class Builder {
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private final class_2561 message;
        private final Consumer<MapSquareButton> onPress;
        private class_2561 tooltip = class_2561.method_43473();
        @Nullable
        private class_2561 disabledTooltip = null;
        @Nullable
        private class_2960 imageLocation = null;
        @Nullable
        private class_2960 animationLocation = null;
        @Nullable
        private class_2960 soundEffectLocation = null;
        private int totalFrames = 0;
        private int tileWidth = 0;
        private int tileHeight = 0;
        @Nullable
        private AnimationFrameRange initialHoverAnimation;
        @Nullable
        private AnimationFrameRange hoverLoopAnimation;
        @Nullable
        private AnimationFrameRange mouseOffAnimation;
        private boolean fixedTooltipPosition = false;
        private float hoverBrightness = 1.0f;
        private float clickBrightness = 1.0f;

        public Builder(int x, int y, int width, int height, class_2561 message, Consumer<MapSquareButton> onPress) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.message = message;
            this.onPress = onPress;
        }

        public Builder tooltip(class_2561 tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder tooltips(class_2561 tooltip, @Nullable class_2561 disabledTooltip) {
            this.tooltip = tooltip;
            this.disabledTooltip = disabledTooltip;
            return this;
        }

        public Builder image(class_2960 imageLocation, int tileWidth, int tileHeight) {
            this.imageLocation = imageLocation;
            this.tileWidth = tileWidth;
            this.tileHeight = tileHeight;
            return this;
        }

        public Builder animation(class_2960 animationLocation, int totalFrames) {
            this.animationLocation = animationLocation;
            this.totalFrames = totalFrames;
            return this;
        }

        public Builder hoverBrightness(float brightness) {
            this.hoverBrightness = brightness;
            return this;
        }

        public Builder clickBrightness(float brightness) {
            this.clickBrightness = brightness;
            return this;
        }

        public Builder soundEffect(class_2960 soundLocation) {
            this.soundEffectLocation = soundLocation;
            return this;
        }

        public Builder initialHover(int start, int end, boolean reverse) {
            if (start != -1 && end != -1) {
                this.initialHoverAnimation = new AnimationFrameRange(start, end, reverse ? AnimationDirection.REVERSE : AnimationDirection.FORWARD);
            }
            return this;
        }

        public Builder hoverLoop(int start, int end, boolean reverse) {
            if (start != -1 && end != -1) {
                this.hoverLoopAnimation = new AnimationFrameRange(start, end, reverse ? AnimationDirection.REVERSE : AnimationDirection.FORWARD);
            }
            return this;
        }

        public Builder mouseOff(int start, int end, boolean reverse) {
            if (start != -1 && end != -1) {
                this.mouseOffAnimation = new AnimationFrameRange(start, end, reverse ? AnimationDirection.REVERSE : AnimationDirection.FORWARD);
            }
            return this;
        }

        public Builder fixedTooltipPosition(boolean fixed) {
            this.fixedTooltipPosition = fixed;
            return this;
        }

        public MapSquareButton build() {
            return new MapSquareButton(this);
        }
    }

    private static class AnimationController {
        private final Builder settings;
        private AnimationState currentState = AnimationState.IDLE;
        private boolean wasHovered = false;
        private long animationStartTime = 0L;

        AnimationController(Builder builder) {
            this.settings = builder;
        }

        public void update(boolean isHovered) {
            if (isHovered && !this.wasHovered) {
                this.startAnimation(AnimationState.HOVER_INITIAL);
            } else if (!isHovered && this.wasHovered) {
                this.startAnimation(AnimationState.MOUSE_OFF);
            }
            this.wasHovered = isHovered;
        }

        private void startAnimation(AnimationState state) {
            this.currentState = state;
            this.animationStartTime = Objects.requireNonNull(class_310.method_1551().field_1687).method_8510();
        }

        public RenderData getRenderData() {
            if (this.settings.animationLocation == null || this.currentState == AnimationState.IDLE) {
                return new RenderData(this.settings.imageLocation, 0, 0, this.settings.tileWidth, this.settings.tileHeight);
            }
            long elapsedTicks = Objects.requireNonNull(class_310.method_1551().field_1687).method_8510() - this.animationStartTime;
            AnimationFrameRange activeRange = this.getActiveRange();
            if (activeRange == null) {
                this.currentState = AnimationState.IDLE;
                return new RenderData(this.settings.imageLocation, 0, 0, this.settings.tileWidth, this.settings.tileHeight);
            }
            int frameCount = activeRange.getFrameCount();
            int frameIndex = (int)elapsedTicks;
            boolean loop = this.isLooping();
            if (!loop && frameIndex >= frameCount) {
                if (this.currentState == AnimationState.HOVER_INITIAL) {
                    this.startAnimation(AnimationState.HOVER_LOOP);
                } else if (this.currentState == AnimationState.MOUSE_OFF) {
                    this.currentState = AnimationState.IDLE;
                }
                frameIndex = frameCount - 1;
            }
            int frameOffset = loop ? frameIndex % frameCount : frameIndex;
            int currentFrame = activeRange.direction == AnimationDirection.REVERSE ? activeRange.startFrame - frameOffset : activeRange.startFrame + frameOffset;
            int vOffset = currentFrame * this.settings.tileHeight;
            return new RenderData(this.settings.animationLocation, 0, vOffset, this.settings.tileWidth, this.settings.totalFrames * this.settings.tileHeight);
        }

        private boolean isLooping() {
            return this.currentState == AnimationState.HOVER_LOOP;
        }

        @Nullable
        private AnimationFrameRange getActiveRange() {
            return switch (this.currentState.ordinal()) {
                case 1 -> this.settings.initialHoverAnimation;
                case 2 -> this.settings.hoverLoopAnimation;
                case 3 -> this.settings.mouseOffAnimation;
                default -> null;
            };
        }

        private static enum AnimationState {
            IDLE,
            HOVER_INITIAL,
            HOVER_LOOP,
            MOUSE_OFF;

        }

        record RenderData(@Nullable class_2960 texture, int u, int v, int textureWidth, int textureHeight) {
        }
    }

    private record AnimationFrameRange(int startFrame, int endFrame, AnimationDirection direction) {
        int getFrameCount() {
            return Math.abs(this.endFrame - this.startFrame) + 1;
        }
    }

    private static enum AnimationDirection {
        FORWARD,
        REVERSE;

    }
}

