/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import java.util.Optional;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.path.PathDataManager;
import net.rasanovum.viaromana.util.PathSyncUtils;
import net.rasanovum.viaromana.util.VersionUtils;

public record RoutedActionC2S(Operation op) implements class_8710
{
    public static final class_8710.class_9154<RoutedActionC2S> TYPE = new class_8710.class_9154(VersionUtils.getLocation("viaromana:action_request_c2s"));
    public static final class_9139<class_2540, RoutedActionC2S> STREAM_CODEC = class_9139.method_56434((class_9139)class_9135.field_48550.method_56432(i -> Operation.values()[i], Enum::ordinal), RoutedActionC2S::op, RoutedActionC2S::new);

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void encode(class_2540 buf, RoutedActionC2S packet) {
        buf.method_10804(packet.op.ordinal());
    }

    public static RoutedActionC2S decode(class_2540 buf) {
        int ordinal = buf.method_10816();
        return new RoutedActionC2S(Operation.values()[ordinal]);
    }

    public static void handle(PacketContext<RoutedActionC2S> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            ctx.sender().field_13995.execute(() -> {
                class_3222 player = ctx.sender();
                class_3218 level = player.method_51469();
                PathGraph graph = PathGraph.getInstance(level);
                Optional<Node> nearestOpt = graph.getNearestNode(player.method_24515(), CommonConfig.node_utility_distance, node -> true);
                if (nearestOpt.isEmpty()) {
                    ViaRomana.LOGGER.warn("No nearby node found for action {} by player {}", (Object)((RoutedActionC2S)ctx.message()).op(), (Object)player.method_5477().getString());
                    return;
                }
                Node nearestNode = nearestOpt.get();
                switch (((RoutedActionC2S)ctx.message()).op().ordinal()) {
                    case 0: {
                        graph.removeNode(nearestNode);
                        break;
                    }
                    case 1: {
                        graph.removeBranch(nearestNode);
                    }
                }
                PathDataManager.markDirty(level);
                PathSyncUtils.syncPathGraphToAllPlayers(level);
            });
        }
    }

    public static enum Operation {
        SEVER_NEAREST_NODE,
        REMOVE_BRANCH;

    }
}

