/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.util;

import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.storage.player.PlayerData;
import net.rasanovum.viaromana.tags.TagGenerator;

public class PathUtils {
    public static int CLEARANCE_CHECK = 32;

    public static float calculateNodeDistance(class_1297 entity) {
        if (!(entity instanceof class_1657)) {
            return 0.0f;
        }
        class_1657 player = (class_1657)entity;
        class_2338 lastNodePos = PlayerData.getLastNodePos(player);
        double dx = player.method_23317() - (double)lastNodePos.method_10263();
        double dy = player.method_23318() - (double)lastNodePos.method_10264();
        double dz = player.method_23321() - (double)lastNodePos.method_10260();
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static boolean isBlockValidPath(class_1936 world, class_2338 targetBlock) {
        if (world.method_22347(targetBlock)) {
            return false;
        }
        class_2680 blockState = world.method_8320(targetBlock);
        return blockState.method_26164(TagGenerator.PATH_BLOCK_TAG);
    }

    public static boolean isBlockLeaveBlock(class_1936 world, class_2338 targetBlock) {
        if (world.method_22347(targetBlock)) {
            return false;
        }
        class_2680 blockState = world.method_8320(targetBlock);
        return blockState.method_26164(TagGenerator.LEAVES_BLOCK_TAG);
    }

    public static float calculateInfrastructureQuality(class_1936 world, class_1297 entity) {
        if (entity == null) {
            return 0.0f;
        }
        class_2338.class_2339 mutablePos = new class_2338.class_2339(entity.method_23317(), entity.method_23318(), entity.method_23321());
        if (!entity.method_24828()) {
            int startY = mutablePos.method_10264();
            while (world.method_22347((class_2338)mutablePos)) {
                mutablePos.method_33098(mutablePos.method_10264() - 1);
                if (startY - mutablePos.method_10264() < 4) continue;
                return 0.0f;
            }
        }
        int surfaceY = mutablePos.method_10264();
        int checkRadius = CommonConfig.infrastructure_check_radius;
        int pathQuality = 0;
        int entityX = (int)Math.floor(entity.method_23317());
        int entityZ = (int)Math.floor(entity.method_23321());
        for (int dx = -checkRadius; dx <= checkRadius; ++dx) {
            for (int dy = -checkRadius; dy <= checkRadius; ++dy) {
                for (int dz = -checkRadius; dz <= checkRadius; ++dz) {
                    mutablePos.method_10103(entityX + dx, surfaceY + dy, entityZ + dz);
                    if (!PathUtils.isBlockValidPath(world, (class_2338)mutablePos)) continue;
                    ++pathQuality;
                }
            }
        }
        float totalBlocksChecked = (float)Math.pow(checkRadius * 2 + 1, 2.0);
        return totalBlocksChecked == 0.0f ? 0.0f : (float)pathQuality / totalBlocksChecked;
    }

    public static float calculateClearance(class_1936 world, class_1297 entity) {
        if (entity == null) {
            return 0.0f;
        }
        class_2338.class_2339 mutablePos = new class_2338.class_2339(entity.method_23317(), entity.method_23318(), entity.method_23321());
        if (!entity.method_24828()) {
            int startY = mutablePos.method_10264();
            while (world.method_22347((class_2338)mutablePos)) {
                mutablePos.method_33098(mutablePos.method_10264() - 1);
                if (startY - mutablePos.method_10264() < 4) continue;
                return 0.0f;
            }
        }
        int surfaceY = mutablePos.method_10264();
        int clearance = 0;
        int entityX = (int)Math.floor(entity.method_23317());
        int entityZ = (int)Math.floor(entity.method_23321());
        for (int y = surfaceY + 1; y <= surfaceY + CLEARANCE_CHECK; ++y) {
            mutablePos.method_10103(entityX, y, entityZ);
            class_2680 blockState = world.method_8320((class_2338)mutablePos);
            if (!world.method_22347((class_2338)mutablePos) && !blockState.method_26164(TagGenerator.LEAVES_BLOCK_TAG)) {
                return clearance;
            }
            ++clearance;
        }
        return 0.0f;
    }
}

