/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.gui.elements;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class MapActionButton
extends AbstractButton {
    private final Consumer<Void> onPress;
    @Nullable
    private final ResourceLocation imageLocation;
    private final boolean hasMessage;

    public MapActionButton(int x, int y, int width, int height, Component message, Component tooltip, Consumer<Void> onPress) {
        this(x, y, width, height, message, tooltip, onPress, null);
    }

    public MapActionButton(int x, int y, int width, int height, Consumer<Void> onPress, ResourceLocation imageLocation) {
        this(x, y, width, height, null, null, onPress, imageLocation);
    }

    public MapActionButton(int x, int y, int width, int height, @Nullable Component message, @Nullable Component tooltip, Consumer<Void> onPress, @Nullable ResourceLocation imageLocation) {
        super(x, y, width, height, (Component)(message != null ? message : Component.empty()));
        this.onPress = onPress;
        this.imageLocation = imageLocation;
        boolean bl = this.hasMessage = message != null;
        if (tooltip != null) {
            this.setTooltip(Tooltip.create((Component)tooltip));
        }
    }

    public void onPress() {
        if (this.onPress != null) {
            this.onPress.accept(null);
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.visible) {
            return;
        }
        if (this.isHovered()) {
            guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, 0x40FFFFFF);
        }
        guiGraphics.hLine(this.getX(), this.getX() + this.width - 1, this.getY(), 4139547);
        guiGraphics.hLine(this.getX(), this.getX() + this.width - 1, this.getY() + this.height - 1, 4139547);
        guiGraphics.vLine(this.getX(), this.getY(), this.getY() + this.height - 1, 4139547);
        guiGraphics.vLine(this.getX() + this.width - 1, this.getY(), this.getY() + this.height - 1, 4139547);
        Font font = Minecraft.getInstance().font;
        int n = this.getY();
        Objects.requireNonNull(font);
        int textY = n + (this.height - 9) / 2 + 1;
        int imageY = this.getY() + (this.height - 10) / 2;
        if (this.imageLocation != null) {
            int imageX = !this.hasMessage ? this.getX() + (this.width - 17) / 2 : this.getX() + 5;
            guiGraphics.blit(this.imageLocation, imageX, imageY, 0.0f, 0.0f, 17, 10, 17, 10);
        }
        if (this.hasMessage) {
            int textX = this.getX() + this.width - font.width((FormattedText)this.getMessage()) - 5;
            guiGraphics.drawString(font, this.getMessage(), textX, textY, 4139547, false);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }
}

