/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.gui.elements;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.rasanovum.viaromana.client.gui.elements.MapCycleButton;

public class MapButtonGroup<T> {
    private final List<MapCycleButton<T>> buttons = new ArrayList<MapCycleButton<T>>();
    private MapCycleButton<T> selectedButton = null;
    private final Consumer<T> onSelectionChange;

    public MapButtonGroup(Consumer<T> onSelectionChange) {
        this.onSelectionChange = onSelectionChange;
    }

    public void addButton(MapCycleButton<T> button) {
        this.buttons.add(button);
        button.setOnPress(() -> this.selectButton(button));
    }

    public void selectButton(MapCycleButton<T> button) {
        if (!this.buttons.contains(button)) {
            return;
        }
        for (MapCycleButton<T> btn : this.buttons) {
            btn.setSelected(false);
        }
        button.setSelected(true);
        this.selectedButton = button;
        if (this.onSelectionChange != null) {
            this.onSelectionChange.accept(button.getValue());
        }
    }

    public void selectByValue(T value) {
        for (MapCycleButton<T> button : this.buttons) {
            if (!button.getValue().equals(value)) continue;
            this.selectButton(button);
            break;
        }
    }

    public T getSelectedValue() {
        return this.selectedButton != null ? (T)this.selectedButton.getValue() : null;
    }

    public MapCycleButton<T> getSelectedButton() {
        return this.selectedButton;
    }
}

