/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.util.VersionUtils;

public record PathGraphSyncPacket(CompoundTag pathGraphData, ResourceKey<Level> dimension) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PathGraphSyncPacket> TYPE = new CustomPacketPayload.Type(VersionUtils.getLocation("via_romana:path_graph_sync_s2c"));
    public static final StreamCodec<FriendlyByteBuf, PathGraphSyncPacket> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, PathGraphSyncPacket>(){

        public PathGraphSyncPacket decode(FriendlyByteBuf buffer) {
            return PathGraphSyncPacket.decode(buffer);
        }

        public void encode(FriendlyByteBuf buffer, PathGraphSyncPacket packet) {
            PathGraphSyncPacket.encode(buffer, packet);
        }
    };

    public PathGraphSyncPacket(PathGraph graph, ResourceKey<Level> dimension) {
        this(graph.serialize(new CompoundTag()), dimension);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void encode(FriendlyByteBuf buf, PathGraphSyncPacket packet) {
        buf.writeNbt((Tag)packet.pathGraphData);
        buf.writeUtf(packet.dimension.location().toString());
    }

    public static PathGraphSyncPacket decode(FriendlyByteBuf buf) {
        CompoundTag data = buf.readNbt();
        String dimensionStr = buf.readUtf();
        ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)VersionUtils.getLocation(dimensionStr));
        return new PathGraphSyncPacket(data, (ResourceKey<Level>)dimension);
    }

    public static void handle(PacketContext<PathGraphSyncPacket> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            try {
                PathGraph clientGraph = new PathGraph();
                clientGraph.deserialize(((PathGraphSyncPacket)ctx.message()).pathGraphData());
                ResourceKey<Level> dimension = ((PathGraphSyncPacket)ctx.message()).dimension();
                ClientPathData.getInstance().updatePathData(clientGraph, dimension);
                ViaRomana.LOGGER.debug("Client received PathGraph sync for dimension {} with {} nodes", (Object)dimension.location(), (Object)clientGraph.size());
            }
            catch (Exception e) {
                ViaRomana.LOGGER.error("Failed to process PathGraph sync packet on client", (Throwable)e);
            }
        }
    }
}

