/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.rasanovum.viaromana.core.LinkHandler;
import net.rasanovum.viaromana.util.VersionUtils;

public record SignUnlinkRequestC2S(BlockPos signPos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SignUnlinkRequestC2S> TYPE = new CustomPacketPayload.Type(VersionUtils.getLocation("via_romana:unlink_sign_request"));
    public static final StreamCodec<FriendlyByteBuf, SignUnlinkRequestC2S> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SignUnlinkRequestC2S::signPos, SignUnlinkRequestC2S::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void encode(FriendlyByteBuf buf, SignUnlinkRequestC2S packet) {
        buf.writeBlockPos(packet.signPos);
    }

    public static SignUnlinkRequestC2S decode(FriendlyByteBuf buf) {
        return new SignUnlinkRequestC2S(buf.readBlockPos());
    }

    public static void handle(PacketContext<SignUnlinkRequestC2S> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            ServerLevel level = ctx.sender().serverLevel();
            BlockPos signPos = ((SignUnlinkRequestC2S)ctx.message()).signPos();
            LinkHandler.unlinkSignFromNode(level, signPos);
        }
    }
}

