/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import commonnetwork.api.Dispatcher;
import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.rasanovum.viaromana.network.packets.SignValidationResponseS2C;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.util.VersionUtils;

public record SignValidationRequestC2S(BlockPos nodePos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SignValidationRequestC2S> TYPE = new CustomPacketPayload.Type(VersionUtils.getLocation("viaromana:sign_validation_c2s"));
    public static final StreamCodec<FriendlyByteBuf, SignValidationRequestC2S> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SignValidationRequestC2S::nodePos, SignValidationRequestC2S::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void encode(FriendlyByteBuf buf, SignValidationRequestC2S packet) {
        buf.writeBlockPos(packet.nodePos);
    }

    public static SignValidationRequestC2S decode(FriendlyByteBuf buf) {
        return new SignValidationRequestC2S(buf.readBlockPos());
    }

    public static void handle(PacketContext<SignValidationRequestC2S> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            ServerLevel level = ctx.sender().serverLevel();
            BlockPos nodePos = ((SignValidationRequestC2S)ctx.message()).nodePos();
            PathGraph graph = PathGraph.getInstance(level);
            boolean isValid = graph.getNodeAt(nodePos).isPresent();
            SignValidationResponseS2C response = new SignValidationResponseS2C(nodePos, isValid);
            Dispatcher.sendToClient((Object)response, (ServerPlayer)ctx.sender());
        }
    }
}

