/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.storage.level;

import dev.corgitaco.dataanchor.data.registry.TrackedDataKey;
import dev.corgitaco.dataanchor.data.type.level.ServerLevelTrackedData;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;

public class LevelCornerTrackedData
extends ServerLevelTrackedData {
    private final Map<String, byte[]> cornerMap = new HashMap<String, byte[]>();

    public LevelCornerTrackedData(TrackedDataKey<? extends ServerLevelTrackedData> trackedDataKey, ServerLevel level) {
        super(trackedDataKey, level);
    }

    public CompoundTag save() {
        if (this.cornerMap.isEmpty()) {
            return null;
        }
        CompoundTag tag = new CompoundTag();
        tag.put("corner_map", (Tag)LevelCornerTrackedData.toNBT(this.cornerMap));
        return tag;
    }

    public void load(CompoundTag tag) {
        if (tag.contains("corner_map")) {
            this.cornerMap.clear();
            this.cornerMap.putAll(LevelCornerTrackedData.fromNBT(tag.getCompound("corner_map")));
        }
    }

    public void setCornerBytes(ChunkPos pos, byte[] bytes) {
        String key = pos.x + "_" + pos.z;
        if (bytes != null && bytes.length == 4) {
            this.cornerMap.put(key, (byte[])bytes.clone());
        } else {
            this.cornerMap.remove(key);
        }
        this.markDirty();
    }

    public Optional<byte[]> getCornerBytes(ChunkPos pos) {
        String key = pos.x + "_" + pos.z;
        byte[] bytes = this.cornerMap.get(key);
        return bytes != null && bytes.length == 4 ? Optional.of((byte[])bytes.clone()) : Optional.empty();
    }

    private static CompoundTag toNBT(Map<String, byte[]> map) {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<String, byte[]> entry : map.entrySet()) {
            tag.putByteArray(entry.getKey(), entry.getValue());
        }
        return tag;
    }

    private static Map<String, byte[]> fromNBT(CompoundTag tag) {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        for (String key : tag.getAllKeys()) {
            map.put(key, tag.getByteArray(key));
        }
        return map;
    }

    public void clearAll() {
        this.cornerMap.clear();
        this.markDirty();
    }
}

