/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_167;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_8779;
import net.minecraft.class_9139;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.map.ServerMapCache;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.path.PathDataManager;
import net.rasanovum.viaromana.util.PathSyncUtils;
import net.rasanovum.viaromana.util.VersionUtils;

public record ChartedPathC2S(List<Node.NodeData> chartedNodes) implements class_8710
{
    public static final class_8710.class_9154<ChartedPathC2S> TYPE = new class_8710.class_9154(VersionUtils.getLocation("via_romana:charted_path_c2s"));
    public static final class_9139<class_2540, ChartedPathC2S> STREAM_CODEC = new class_9139<class_2540, ChartedPathC2S>(){

        public ChartedPathC2S decode(class_2540 buffer) {
            return ChartedPathC2S.decode(buffer);
        }

        public void encode(class_2540 buffer, ChartedPathC2S packet) {
            ChartedPathC2S.encode(buffer, packet);
        }
    };

    public ChartedPathC2S(List<Node.NodeData> chartedNodes) {
        this.chartedNodes = chartedNodes != null ? List.copyOf(chartedNodes) : List.of();
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void encode(class_2540 buffer, ChartedPathC2S packet) {
        buffer.method_53002(packet.chartedNodes.size());
        for (Node.NodeData nodeData : packet.chartedNodes) {
            buffer.method_10807(nodeData.pos());
            buffer.method_52941(nodeData.quality());
            buffer.method_52941(nodeData.clearance());
        }
    }

    public static ChartedPathC2S decode(class_2540 buffer) {
        int nodeCount = buffer.readInt();
        ArrayList<Node.NodeData> nodes = new ArrayList<Node.NodeData>(nodeCount);
        for (int i = 0; i < nodeCount; ++i) {
            class_2338 pos = buffer.method_10811();
            float quality = buffer.readFloat();
            float clearance = buffer.readFloat();
            nodes.add(new Node.NodeData(pos, quality, clearance));
        }
        return new ChartedPathC2S(nodes);
    }

    public static void handle(PacketContext<ChartedPathC2S> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            class_3218 level = ctx.sender().method_51469();
            PathGraph graph = PathGraph.getInstance(level);
            UUID playerUUID = ctx.sender().method_5667();
            List<Node.NodeData> chartingNodes = ((ChartedPathC2S)ctx.message()).chartedNodes();
            if (chartingNodes.isEmpty()) {
                ViaRomana.LOGGER.warn("Received empty charted path from player {}", (Object)ctx.sender().method_5477().getString());
                return;
            }
            try {
                graph.createConnectedPath(chartingNodes);
                PathDataManager.markDirty(level);
                PathSyncUtils.syncPathGraphToAllPlayers(level);
                ChartedPathC2S.awardAdvancementIfNeeded(ctx.sender());
                UUID pseudoNetworkId = ServerMapCache.getPseudoNetworkId(playerUUID);
                ServerMapCache.invalidatePseudoNetwork(pseudoNetworkId);
                ViaRomana.LOGGER.debug("Created charted path with {} nodes for player {}, cleaned up pseudonetwork {}", (Object)chartingNodes.size(), (Object)ctx.sender().method_5477().getString(), (Object)pseudoNetworkId);
            }
            catch (Exception e) {
                ViaRomana.LOGGER.error("Failed to create charted path for player {}: {}", (Object)ctx.sender().method_5477().getString(), (Object)e.getMessage());
            }
        }
    }

    private static void awardAdvancementIfNeeded(class_3222 player) {
        try {
            class_167 advancementProgress;
            class_2960 advancementId = VersionUtils.getLocation("via_romana:story/a_strand_type_game");
            class_8779 advancement = player.field_13995.method_3851().method_12896(advancementId);
            if (advancement != null && !(advancementProgress = player.method_14236().method_12882(advancement)).method_740()) {
                boolean grantedAny = false;
                for (String criterion : advancementProgress.method_731()) {
                    boolean granted = player.method_14236().method_12878(advancement, criterion);
                    if (!granted) continue;
                    grantedAny = true;
                }
                if (grantedAny) {
                    player.method_14236().method_12876(player);
                }
            }
        }
        catch (Exception e) {
            ViaRomana.LOGGER.warn("Failed to award advancement {} to player {}: {}", (Object)"via_romana:story/a_strand_type_game", (Object)player.method_5477().getString(), (Object)e.getMessage());
        }
    }
}

