/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.util.VersionUtils;

public record PathGraphSyncPacket(class_2487 pathGraphData, class_5321<class_1937> dimension) implements class_8710
{
    public static final class_8710.class_9154<PathGraphSyncPacket> TYPE = new class_8710.class_9154(VersionUtils.getLocation("via_romana:path_graph_sync_s2c"));
    public static final class_9139<class_2540, PathGraphSyncPacket> STREAM_CODEC = new class_9139<class_2540, PathGraphSyncPacket>(){

        public PathGraphSyncPacket decode(class_2540 buffer) {
            return PathGraphSyncPacket.decode(buffer);
        }

        public void encode(class_2540 buffer, PathGraphSyncPacket packet) {
            PathGraphSyncPacket.encode(buffer, packet);
        }
    };

    public PathGraphSyncPacket(PathGraph graph, class_5321<class_1937> dimension) {
        this(graph.serialize(new class_2487()), dimension);
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void encode(class_2540 buf, PathGraphSyncPacket packet) {
        buf.method_10794((class_2520)packet.pathGraphData);
        buf.method_10814(packet.dimension.method_29177().toString());
    }

    public static PathGraphSyncPacket decode(class_2540 buf) {
        class_2487 data = buf.method_10798();
        String dimensionStr = buf.method_19772();
        class_5321 dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)VersionUtils.getLocation(dimensionStr));
        return new PathGraphSyncPacket(data, (class_5321<class_1937>)dimension);
    }

    public static void handle(PacketContext<PathGraphSyncPacket> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            try {
                PathGraph clientGraph = new PathGraph();
                clientGraph.deserialize(((PathGraphSyncPacket)ctx.message()).pathGraphData());
                class_5321<class_1937> dimension = ((PathGraphSyncPacket)ctx.message()).dimension();
                ClientPathData.getInstance().updatePathData(clientGraph, dimension);
                ViaRomana.LOGGER.debug("Client received PathGraph sync for dimension {} with {} nodes", (Object)dimension.method_29177(), (Object)clientGraph.size());
            }
            catch (Exception e) {
                ViaRomana.LOGGER.error("Failed to process PathGraph sync packet on client", (Throwable)e);
            }
        }
    }
}

