/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.gui;

import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.IntStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_332;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.client.MapClient;
import net.rasanovum.viaromana.client.gui.MapCoordinateSystem;
import net.rasanovum.viaromana.util.VersionUtils;

@Environment(value=EnvType.CLIENT)
public class MapRenderer
implements AutoCloseable {
    private static final int SCREEN_MARGIN = 40;
    private static final int BACKGROUND_TILE_SIZE = 32;
    private static final float MIN_VISIBLE_TILE_FRACTION = 0.4f;
    private static final float GRADIENT_RANDOMNESS = 0.3f;
    private static final float MAP_OPACITY = 0.75f;
    private static final int BIOME_LAYER_BLUR_RADIUS = 2;
    private static final class_2960[] CORNER_TILES = MapRenderer.createTileLocations("corner-", 4);
    private static final class_2960[] EDGE_TILES = MapRenderer.createTileLocations("edge-", 24);
    private static final class_2960[] CENTER_TILES = MapRenderer.createTileLocations("center-", 4);
    private static final Map<class_2960, class_1011> tileImageCache = new ConcurrentHashMap<class_2960, class_1011>();
    private final long tileSeed;
    private MapClient.MapTexture mapTexture;
    private class_1043 bakedDynamicTexture;
    private class_2960 bakedTextureLocation;
    private MapCoordinateSystem coordinateSystem;
    private float lastRenderScale = -1.0f;
    private int bakedTextureWidth;
    private int bakedTextureHeight;

    public MapRenderer(class_2338 minBounds, class_2338 maxBounds) {
        this.tileSeed = (long)minBounds.hashCode() * 31L + (long)maxBounds.hashCode();
    }

    public void setMapTexture(MapClient.MapTexture mapTexture) {
        this.mapTexture = mapTexture;
    }

    public void render(class_332 guiGraphics, int screenWidth, int screenHeight) {
        if (this.mapTexture == null) {
            return;
        }
        int availableWidth = screenWidth - 40;
        int availableHeight = screenHeight - 40;
        float scale = Math.min((float)availableWidth / (float)this.mapTexture.biomeImage().method_4307(), (float)availableHeight / (float)this.mapTexture.biomeImage().method_4323());
        if (this.bakedDynamicTexture == null || Math.abs(scale - this.lastRenderScale) > 0.1f) {
            this.rebuildBakedTexture(scale);
        }
        if (this.bakedDynamicTexture == null || this.coordinateSystem == null) {
            return;
        }
        MapCoordinateSystem.MapRenderInfo renderInfo = this.coordinateSystem.updateAndGetRenderInfo(screenWidth, screenHeight);
        guiGraphics.method_25293(this.bakedTextureLocation, renderInfo.x, renderInfo.y, renderInfo.width, renderInfo.height, 0.0f, 0.0f, this.bakedTextureWidth, this.bakedTextureHeight, this.bakedTextureWidth, this.bakedTextureHeight);
    }

    public Point worldToScreen(class_2338 worldPos, int screenWidth, int screenHeight) {
        if (this.coordinateSystem == null) {
            return null;
        }
        this.coordinateSystem.updateAndGetRenderInfo(screenWidth, screenHeight);
        return this.coordinateSystem.worldToScreen(worldPos);
    }

    @Override
    public void close() {
        if (this.bakedDynamicTexture != null) {
            this.bakedDynamicTexture.close();
            this.bakedDynamicTexture = null;
            this.bakedTextureLocation = null;
        }
    }

    private void rebuildBakedTexture(float scale) {
        this.lastRenderScale = scale;
        if (this.bakedDynamicTexture != null) {
            this.bakedDynamicTexture.close();
        }
        try (class_1011 newBakedImage = this.bakeLayersOnBackground(this.mapTexture.biomeImage(), this.mapTexture.chunkImage());){
            this.bakedTextureWidth = newBakedImage.method_4307();
            this.bakedTextureHeight = newBakedImage.method_4323();
            this.bakedDynamicTexture = new class_1043(newBakedImage);
            this.bakedTextureLocation = class_310.method_1551().method_1531().method_4617("baked_map", this.bakedDynamicTexture);
        }
        class_2338 imageMin = new class_2338(this.mapTexture.mapInfo().worldMinX(), 0, this.mapTexture.mapInfo().worldMinZ());
        class_2338 imageMax = new class_2338(this.mapTexture.mapInfo().worldMaxX(), 0, this.mapTexture.mapInfo().worldMaxZ());
        this.coordinateSystem = new MapCoordinateSystem(imageMin, imageMax, this.mapTexture.biomeImage().method_4307(), this.mapTexture.biomeImage().method_4323(), this.bakedTextureWidth, this.bakedTextureHeight, this.mapTexture.mapInfo().scaleFactor());
    }

    private class_1011 bakeLayersOnBackground(class_1011 biomeImage, class_1011 chunkImage) {
        int mapWidthPx = biomeImage.method_4307();
        int mapHeightPx = biomeImage.method_4323();
        int padding = (int)Math.ceil(12.8f);
        int requiredWidth = mapWidthPx + 2 * padding;
        int requiredHeight = mapHeightPx + 2 * padding;
        int tilesWide = Math.max(3, (requiredWidth + 32 - 1) / 32);
        int tilesHigh = Math.max(3, (requiredHeight + 32 - 1) / 32);
        class_1011 stackedMap = new class_1011(biomeImage.method_4318(), mapWidthPx, mapHeightPx, false);
        try (class_1011 biomeWithOpacity = this.applyImageOpacity(biomeImage, CommonConfig.biome_map_opacity);){
            stackedMap.method_4317(biomeWithOpacity);
        }
        try (class_1011 biomeWithBlur = this.applyImageBlur(stackedMap, 2);){
            stackedMap.method_4317(biomeWithBlur);
        }
        try (class_1011 chunkGradient = this.applyEdgeGradient(chunkImage, 12);){
            this.blendImage(stackedMap, chunkGradient, 0, 0, 1.0f);
        }
        class_1011 combined = this.createTiledBackground(tilesWide, tilesHigh);
        try (class_1011 mapGradient = this.applyEdgeGradient(stackedMap, 5);){
            int mapX = (combined.method_4307() - mapWidthPx) / 2;
            int mapY = (combined.method_4323() - mapHeightPx) / 2;
            this.blendImage(combined, mapGradient, mapX, mapY, 0.75f);
        }
        stackedMap.close();
        return combined;
    }

    private class_1011 createTiledBackground(int tilesWide, int tilesHigh) {
        int bakedWidth = tilesWide * 32;
        int bakedHeight = tilesHigh * 32;
        class_1011 background = new class_1011(class_1011.class_1012.field_4997, bakedWidth, bakedHeight, true);
        for (int tileY = 0; tileY < tilesHigh; ++tileY) {
            for (int tileX = 0; tileX < tilesWide; ++tileX) {
                TileInfo tileInfo = this.getTileInfo(tileX, tileY, tilesWide, tilesHigh);
                class_1011 source = this.getCachedTileImage(tileInfo.texture());
                if (source == null) continue;
                class_1011 rotated = this.rotateImage(source, tileInfo.rotation());
                this.blitScaled(background, rotated, tileX * 32, tileY * 32, 32, 32);
                if (rotated == source) continue;
                rotated.close();
            }
        }
        return background;
    }

    private class_1011 applyEdgeGradient(class_1011 mapImage, int percentDistance) {
        int width = mapImage.method_4307();
        int height = mapImage.method_4323();
        float[][] distanceMap = this.calculateDistanceMap(mapImage);
        int gradientDist = Math.max(2, Math.min(width, height) / (100 / percentDistance));
        class_1011 result = new class_1011(mapImage.method_4318(), width, height, false);
        result.method_4317(mapImage);
        Random gradientRandom = new Random(this.tileSeed);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float distance = distanceMap[x][y];
                if (!(distance < (float)gradientDist)) continue;
                float randomFactor = 1.0f + (gradientRandom.nextFloat() - 0.5f) * 0.3f;
                float gradient = Math.min(1.0f, distance * randomFactor / (float)gradientDist);
                gradient = gradient * gradient * (3.0f - 2.0f * gradient);
                int pixel = result.method_4315(x, y);
                int adjustedPixel = MapRenderer.applyOpacity(pixel, gradient);
                result.method_4305(x, y, adjustedPixel);
            }
        }
        return result;
    }

    private float[][] calculateDistanceMap(class_1011 image) {
        int x;
        int y;
        int width = image.method_4307();
        int height = image.method_4323();
        float[][] distanceMap = new float[width][height];
        float maxDist = (float)width + (float)height;
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                boolean isTransparent = (image.method_4315(x, y) >>> 24 & 0xFF) < 10;
                boolean isBorder = x == 0 || y == 0 || x == width - 1 || y == height - 1;
                distanceMap[x][y] = isTransparent || isBorder ? 0.0f : maxDist;
            }
        }
        for (y = 1; y < height; ++y) {
            for (x = 1; x < width; ++x) {
                float minNeighbor = Math.min(distanceMap[x - 1][y], distanceMap[x][y - 1]);
                distanceMap[x][y] = Math.min(distanceMap[x][y], minNeighbor + 1.0f);
            }
        }
        for (y = height - 2; y >= 0; --y) {
            for (x = width - 2; x >= 0; --x) {
                float minNeighbor = Math.min(distanceMap[x + 1][y], distanceMap[x][y + 1]);
                distanceMap[x][y] = Math.min(distanceMap[x][y], minNeighbor + 1.0f);
            }
        }
        return distanceMap;
    }

    private void blendImage(class_1011 background, class_1011 foreground, int startX, int startY, float opacity) {
        for (int px = 0; px < foreground.method_4307(); ++px) {
            for (int py = 0; py < foreground.method_4323(); ++py) {
                int targetX = startX + px;
                int targetY = startY + py;
                if (targetX < 0 || targetX >= background.method_4307() || targetY < 0 || targetY >= background.method_4323()) continue;
                int bgPixel = background.method_4315(targetX, targetY);
                int fgPixel = MapRenderer.applyOpacity(foreground.method_4315(px, py), opacity);
                background.method_4305(targetX, targetY, this.blendOver(bgPixel, fgPixel));
            }
        }
    }

    private class_1011 rotateImage(class_1011 src, int degrees) {
        if (degrees == 0) {
            return src;
        }
        int sw = src.method_4307();
        int sh = src.method_4323();
        int dw = degrees == 90 || degrees == 270 ? sh : sw;
        int dh = degrees == 90 || degrees == 270 ? sw : sh;
        class_1011 dest = new class_1011(src.method_4318(), dw, dh, false);
        for (int sx = 0; sx < sw; ++sx) {
            block6: for (int sy = 0; sy < sh; ++sy) {
                int dy;
                int dx;
                switch (degrees) {
                    case 90: {
                        dx = sh - 1 - sy;
                        dy = sx;
                        break;
                    }
                    case 180: {
                        dx = sw - 1 - sx;
                        dy = sh - 1 - sy;
                        break;
                    }
                    case 270: {
                        dx = sy;
                        dy = sw - 1 - sx;
                        break;
                    }
                    default: {
                        continue block6;
                    }
                }
                dest.method_4305(dx, dy, src.method_4315(sx, sy));
            }
        }
        return dest;
    }

    private void blitScaled(class_1011 target, class_1011 src, int tx, int ty, int tw, int th) {
        for (int dy = 0; dy < th; ++dy) {
            for (int dx = 0; dx < tw; ++dx) {
                int sx = (int)((float)dx * (float)src.method_4307() / (float)tw);
                int sy = (int)((float)dy * (float)src.method_4323() / (float)th);
                if (dx + tx >= target.method_4307() || dy + ty >= target.method_4323()) continue;
                target.method_4305(dx + tx, dy + ty, src.method_4315(sx, sy));
            }
        }
    }

    private TileInfo getTileInfo(int tileX, int tileY, int tilesWide, int tilesHigh) {
        boolean isRight;
        Random tileRandom = new Random(this.tileSeed + (long)tileY * (long)tilesWide + (long)tileX);
        boolean isTop = tileY == 0;
        boolean isBottom = tileY == tilesHigh - 1;
        boolean isLeft = tileX == 0;
        boolean bl = isRight = tileX == tilesWide - 1;
        if (isTop && isLeft) {
            return new TileInfo(CORNER_TILES[0], 0);
        }
        if (isTop && isRight) {
            return new TileInfo(CORNER_TILES[1], 0);
        }
        if (isBottom && isLeft) {
            return new TileInfo(CORNER_TILES[2], 0);
        }
        if (isBottom && isRight) {
            return new TileInfo(CORNER_TILES[3], 0);
        }
        class_2960 edgeTexture = EDGE_TILES[tileRandom.nextInt(EDGE_TILES.length)];
        if (isTop) {
            return new TileInfo(edgeTexture, 0);
        }
        if (isRight) {
            return new TileInfo(edgeTexture, 90);
        }
        if (isBottom) {
            return new TileInfo(edgeTexture, 180);
        }
        if (isLeft) {
            return new TileInfo(edgeTexture, 270);
        }
        return new TileInfo(CENTER_TILES[tileRandom.nextInt(CENTER_TILES.length)], 0);
    }

    private class_1011 getCachedTileImage(class_2960 location) {
        return tileImageCache.computeIfAbsent(location, loc -> {
            block8: {
                class_1011 class_10112;
                block9: {
                    Optional resourceOpt = class_310.method_1551().method_1478().method_14486(loc);
                    if (!resourceOpt.isPresent()) break block8;
                    InputStream inputStream = ((class_3298)resourceOpt.get()).method_14482();
                    try {
                        class_10112 = class_1011.method_4309((InputStream)inputStream);
                        if (inputStream == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            ViaRomana.LOGGER.error("Failed to load background tile texture: {}", loc, (Object)e);
                        }
                    }
                    inputStream.close();
                }
                return class_10112;
            }
            return null;
        });
    }

    private static int applyOpacity(int color, float opacity) {
        int alpha = (int)((float)(color >>> 24 & 0xFF) * opacity);
        return alpha << 24 | color & 0xFFFFFF;
    }

    private class_1011 applyImageOpacity(class_1011 source, float opacity) {
        int width = source.method_4307();
        int height = source.method_4323();
        class_1011 result = new class_1011(source.method_4318(), width, height, false);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixel = source.method_4315(x, y);
                int adjustedPixel = MapRenderer.applyOpacity(pixel, opacity);
                result.method_4305(x, y, adjustedPixel);
            }
        }
        return result;
    }

    private class_1011 applyImageBlur(class_1011 source, int blurRadius) {
        if (blurRadius < 1) {
            return source;
        }
        class_1011 temp = this.applyBlurPass(source, blurRadius, true);
        class_1011 result = this.applyBlurPass(temp, blurRadius, false);
        temp.close();
        return result;
    }

    private class_1011 applyBlurPass(class_1011 source, int blurRadius, boolean horizontal) {
        int width = source.method_4307();
        int height = source.method_4323();
        class_1011 result = new class_1011(source.method_4318(), width, height, false);
        int kernelSize = 2 * blurRadius + 1;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int sumA = 0;
                int sumR = 0;
                int sumG = 0;
                int sumB = 0;
                for (int k = -blurRadius; k <= blurRadius; ++k) {
                    int sampleY;
                    int sampleX;
                    if (horizontal) {
                        sampleX = Math.min(width - 1, Math.max(0, x + k));
                        sampleY = y;
                    } else {
                        sampleX = x;
                        sampleY = Math.min(height - 1, Math.max(0, y + k));
                    }
                    int pixel = source.method_4315(sampleX, sampleY);
                    sumA += pixel >> 24 & 0xFF;
                    sumR += pixel >> 16 & 0xFF;
                    sumG += pixel >> 8 & 0xFF;
                    sumB += pixel & 0xFF;
                }
                int avgA = sumA / kernelSize;
                int avgR = sumR / kernelSize;
                int avgG = sumG / kernelSize;
                int avgB = sumB / kernelSize;
                result.method_4305(x, y, avgA << 24 | avgR << 16 | avgG << 8 | avgB);
            }
        }
        return result;
    }

    private int blendOver(int bg, int fg) {
        int fgA = fg >> 24 & 0xFF;
        if (fgA == 0) {
            return bg;
        }
        int bgA = bg >> 24 & 0xFF;
        int invA = 255 - fgA;
        int outR = ((fg >> 16 & 0xFF) * fgA + (bg >> 16 & 0xFF) * invA) / 255;
        int outG = ((fg >> 8 & 0xFF) * fgA + (bg >> 8 & 0xFF) * invA) / 255;
        int outB = ((fg & 0xFF) * fgA + (bg & 0xFF) * invA) / 255;
        int outA = fgA + bgA * invA / 255;
        return outA << 24 | outR << 16 | outG << 8 | outB;
    }

    private static class_2960[] createTileLocations(String prefix, int count) {
        String basePath = "via_romana:textures/screens/background_tile/";
        return (class_2960[])IntStream.range(1, count + 1).mapToObj(i -> VersionUtils.getLocation(basePath + prefix + i + ".png")).toArray(class_2960[]::new);
    }

    public static void clearCache() {
        ViaRomana.LOGGER.info("Clearing MapRenderer tile image cache ({} entries)", (Object)tileImageCache.size());
        tileImageCache.values().forEach(class_1011::close);
        tileImageCache.clear();
    }

    private record TileInfo(class_2960 texture, int rotation) {
    }

    public static class Holder {
        private MapRenderer current;
        private MapKey lastKey;

        public MapRenderer getOrCreate(class_2338 minBounds, class_2338 maxBounds) {
            MapKey currentKey = new MapKey(minBounds, maxBounds);
            if (this.current == null || !currentKey.equals(this.lastKey)) {
                if (this.current != null) {
                    this.current.close();
                }
                this.current = new MapRenderer(minBounds, maxBounds);
                this.lastKey = currentKey;
            }
            return this.current;
        }

        public void close() {
            if (this.current != null) {
                this.current.close();
                this.current = null;
            }
        }
    }

    private record MapKey(class_2338 min, class_2338 max) {
    }
}

