/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.util.VersionUtils;

public record DestinationResponseS2C(List<DestinationInfo> destinations, class_2338 signPos, class_2338 sourceNodePos, List<NodeNetworkInfo> networkNodes, UUID networkId) {
    public static final class_2960 TYPE = VersionUtils.getLocation("via_romana:destination_response");
    public static final Object STREAM_CODEC = null;

    public static void encode(class_2540 buf, DestinationResponseS2C packet) {
        buf.method_10807(packet.signPos);
        buf.method_10807(packet.sourceNodePos);
        buf.method_10797(packet.networkId);
        buf.writeInt(packet.destinations.size());
        for (DestinationInfo dest : packet.destinations) {
            buf.method_10807(dest.position);
            buf.method_10814(dest.name);
            buf.writeDouble(dest.distance);
            buf.method_10814(dest.icon.name());
        }
        buf.writeInt(packet.networkNodes.size());
        for (NodeNetworkInfo node : packet.networkNodes) {
            buf.method_10807(node.position);
            buf.writeFloat(node.clearance);
            buf.writeInt(node.connections.size());
            for (class_2338 connection : node.connections) {
                buf.method_10807(connection);
            }
        }
    }

    public static DestinationResponseS2C decode(class_2540 buf) {
        class_2338 signPos = buf.method_10811();
        class_2338 sourceNodePos = buf.method_10811();
        UUID networkId = buf.method_10790();
        int size = buf.readInt();
        ArrayList<DestinationInfo> destinations = new ArrayList<DestinationInfo>(size);
        for (int i = 0; i < size; ++i) {
            destinations.add(new DestinationInfo(buf.method_10811(), buf.method_19772(), buf.readDouble(), Node.Icon.valueOf(buf.method_19772())));
        }
        int networkSize = buf.readInt();
        ArrayList<NodeNetworkInfo> networkNodes = new ArrayList<NodeNetworkInfo>(networkSize);
        for (int i = 0; i < networkSize; ++i) {
            class_2338 pos = buf.method_10811();
            float clearance = buf.readFloat();
            int connectionCount = buf.readInt();
            ArrayList<class_2338> connections = new ArrayList<class_2338>(connectionCount);
            for (int j = 0; j < connectionCount; ++j) {
                connections.add(buf.method_10811());
            }
            networkNodes.add(new NodeNetworkInfo(pos, clearance, connections));
        }
        return new DestinationResponseS2C(destinations, signPos, sourceNodePos, networkNodes, networkId);
    }

    public static class DestinationInfo {
        public final class_2338 position;
        public final String name;
        public final double distance;
        public final Node.Icon icon;

        public DestinationInfo(class_2338 position, String name, double distance, Node.Icon icon) {
            this.position = position;
            this.name = name;
            this.distance = distance;
            this.icon = icon;
        }
    }

    public static class NodeNetworkInfo {
        public final class_2338 position;
        public final float clearance;
        public final List<class_2338> connections;

        public NodeNetworkInfo(class_2338 position, float clearance, List<class_2338> connections) {
            this.position = position;
            this.clearance = clearance;
            this.connections = connections;
        }
    }
}

