/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.storage.player;

import dev.corgitaco.dataanchor.data.TrackedDataContainer;
import dev.corgitaco.dataanchor.data.registry.TrackedDataRegistries;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.rasanovum.viaromana.init.DataInit;
import net.rasanovum.viaromana.storage.player.PlayerTrackedData;

public class PlayerData {
    private static <T> T getValue(class_1657 player, Function<PlayerTrackedData, T> getter, T defaultValue) {
        TrackedDataContainer container = TrackedDataRegistries.ENTITY.getContainer((Object)player);
        if (container == null) {
            return defaultValue;
        }
        return container.dataAnchor$getTrackedData(DataInit.PLAYER_DATA_KEY).filter(data -> data instanceof PlayerTrackedData).map(getter).orElse(defaultValue);
    }

    private static void setValue(class_1657 player, Consumer<PlayerTrackedData> setter) {
        TrackedDataContainer container = TrackedDataRegistries.ENTITY.getContainer((Object)player);
        if (container == null) {
            return;
        }
        Optional<PlayerTrackedData> existing = container.dataAnchor$getTrackedData(DataInit.PLAYER_DATA_KEY).filter(data -> data instanceof PlayerTrackedData);
        if (existing.isEmpty()) {
            container.dataAnchor$createTrackedData();
        }
        container.dataAnchor$getTrackedData(DataInit.PLAYER_DATA_KEY).filter(data -> data instanceof PlayerTrackedData).ifPresent(setter);
    }

    public static boolean isChartingPath(class_1657 player) {
        return PlayerData.getValue(player, PlayerTrackedData::isChartingPath, false);
    }

    public static void setChartingPath(class_1657 player, boolean value) {
        PlayerData.setValue(player, data -> data.setChartingPath(value));
    }

    public static class_2338 getLastNodePos(class_1657 player) {
        return PlayerData.getValue(player, PlayerTrackedData::getLastNodePos, null);
    }

    public static void setLastNodePos(class_1657 player, class_2338 value, boolean sync) {
        PlayerData.setValue(player, data -> data.setLastNodePos(value, sync));
    }

    public static void setReceivedTutorial(class_1657 player, boolean value) {
        PlayerData.setValue(player, data -> data.setReceivedTutorial(value));
    }

    public static void resetVariables(class_1657 player) {
        PlayerData.setValue(player, PlayerTrackedData::resetVariables);
    }
}

