/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.util;

import commonnetwork.api.Dispatcher;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.integration.IntegrationManager;
import net.rasanovum.viaromana.network.packets.ConfigSyncS2C;
import net.rasanovum.viaromana.network.packets.PathGraphSyncPacket;
import net.rasanovum.viaromana.path.PathGraph;

public class PathSyncUtils {
    public static void syncPathGraphToAllPlayers(class_3218 level) {
        try {
            PathGraph graph = PathGraph.getInstance(level);
            if (CommonConfig.enable_surveyor_landmark && CommonConfig.enable_surveyor_landmark_coloring) {
                try {
                    IntegrationManager.updateAllNetworkColors(graph, level);
                }
                catch (NullPointerException e) {
                    ViaRomana.LOGGER.warn("Surveyor landmark system not ready yet, skipping network color update for sync");
                }
            }
            PathGraphSyncPacket packet = new PathGraphSyncPacket(graph, (class_5321<class_1937>)level.method_27983());
            for (class_3222 player2 : level.method_18766(player -> true)) {
                Dispatcher.sendToClient((Object)packet, (class_3222)player2);
            }
            ViaRomana.LOGGER.debug("Synced PathGraph with {} nodes to {} players", (Object)graph.size(), (Object)level.method_18766(player -> true).size());
        }
        catch (Exception e) {
            ViaRomana.LOGGER.error("Failed to sync PathGraph to players in level " + String.valueOf(level.method_27983().method_29177()), (Throwable)e);
        }
    }

    public static void syncPathGraphToPlayer(class_3222 player) {
        try {
            class_3218 level = player.method_51469();
            PathGraph graph = PathGraph.getInstance(level);
            PathGraphSyncPacket packet = new PathGraphSyncPacket(graph, (class_5321<class_1937>)level.method_27983());
            Dispatcher.sendToClient((Object)packet, (class_3222)player);
            ViaRomana.LOGGER.debug("Synced PathGraph with {} nodes to player {}", (Object)graph.size(), (Object)player.method_5477().getString());
        }
        catch (Exception e) {
            ViaRomana.LOGGER.error("Failed to sync PathGraph to player " + player.method_5477().getString(), (Throwable)e);
        }
    }

    public static void syncNetworkInvalidationToPlayers(class_3218 level, int networkId) {
    }

    public static void syncConfigToPlayer(class_3222 player) {
        try {
            ConfigSyncS2C packet = new ConfigSyncS2C(CommonConfig.path_quality_threshold, CommonConfig.node_distance_minimum, CommonConfig.node_distance_maximum, CommonConfig.node_utility_distance, CommonConfig.infrastructure_check_radius);
            Dispatcher.sendToClient((Object)packet, (class_3222)player);
            ViaRomana.LOGGER.debug("Synced config to player {}", (Object)player.method_5477().getString());
        }
        catch (Exception e) {
            ViaRomana.LOGGER.error("Failed to sync config to player " + player.method_5477().getString(), (Throwable)e);
        }
    }

    public static void syncConfigToAllPlayers(MinecraftServer server) {
        try {
            ConfigSyncS2C packet = new ConfigSyncS2C(CommonConfig.path_quality_threshold, CommonConfig.node_distance_minimum, CommonConfig.node_distance_maximum, CommonConfig.node_utility_distance, CommonConfig.infrastructure_check_radius);
            for (class_3222 player : server.method_3760().method_14571()) {
                Dispatcher.sendToClient((Object)packet, (class_3222)player);
            }
            ViaRomana.LOGGER.debug("Synced config to {} players", (Object)server.method_3760().method_14574());
        }
        catch (Exception e) {
            ViaRomana.LOGGER.error("Failed to sync config to all players", (Throwable)e);
        }
    }
}

