/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.rasanovum.viaromana.core.LinkHandler;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import org.jetbrains.annotations.Nullable;

public class ClientPathData {
    private static ClientPathData INSTANCE = new ClientPathData();
    private final Map<class_5321<class_1937>, PathGraph> graphByDimension = new HashMap<class_5321<class_1937>, PathGraph>();
    private boolean hasData = false;
    private final List<Node.NodeData> temporaryNodes = new ArrayList<Node.NodeData>();
    private final List<LinkHandler.LinkData> temporaryLinks = new ArrayList<LinkHandler.LinkData>();

    public static ClientPathData getInstance() {
        return INSTANCE;
    }

    public void updatePathData(PathGraph serverGraph, class_5321<class_1937> dimension) {
        this.graphByDimension.put(dimension, serverGraph);
        this.hasData = true;
    }

    public PathGraph getGraph(class_5321<class_1937> dimension) {
        return this.hasData ? this.graphByDimension.get(dimension) : null;
    }

    @Deprecated
    public PathGraph getGraph() {
        return this.hasData && !this.graphByDimension.isEmpty() ? this.graphByDimension.values().iterator().next() : null;
    }

    public boolean hasValidData() {
        return this.hasData && !this.graphByDimension.isEmpty();
    }

    public void clearData() {
        this.graphByDimension.clear();
        this.hasData = false;
        this.temporaryNodes.clear();
        this.temporaryLinks.clear();
    }

    public void addTemporaryNode(class_2338 pos, float quality, float clearance) {
        this.temporaryNodes.add(new Node.NodeData(pos, quality, clearance));
    }

    public void removeTemporaryNode(class_2338 pos) {
        this.temporaryNodes.removeIf(node -> node.pos().equals((Object)pos));
    }

    public void clearTemporaryNodes() {
        this.temporaryNodes.clear();
        this.temporaryLinks.clear();
    }

    public List<Node.NodeData> getTemporaryNodes() {
        return Collections.unmodifiableList(this.temporaryNodes);
    }

    public float getTemporaryNodeQuality(class_2338 pos) {
        return this.temporaryNodes.stream().filter(node -> node.pos().equals((Object)pos)).findFirst().map(Node.NodeData::quality).orElse(Float.valueOf(1.0f)).floatValue();
    }

    public boolean isTemporaryNode(class_2338 pos) {
        return this.temporaryNodes.stream().anyMatch(node -> node.pos().equals((Object)pos));
    }

    public void addTemporaryLink(LinkHandler.LinkData linkData) {
        this.temporaryLinks.removeIf(link -> link.signPos().equals((Object)linkData.signPos()));
        this.temporaryLinks.add(linkData);
    }

    public void removeTemporaryLink(LinkHandler.LinkData linkData) {
        this.temporaryLinks.removeIf(link -> link.equals(linkData));
    }

    public void clearTemporaryLinks() {
        this.temporaryLinks.clear();
    }

    public List<LinkHandler.LinkData> getTemporaryLinks() {
        return Collections.unmodifiableList(this.temporaryLinks);
    }

    public Optional<LinkHandler.LinkData> getTemporaryNodeLink(class_2338 nodePos) {
        return this.temporaryLinks.stream().filter(link -> link.nodePos().equals((Object)nodePos)).findFirst();
    }

    public Optional<LinkHandler.LinkData> getTemporarySignLink(class_2338 signPos) {
        return this.temporaryLinks.stream().filter(link -> link.signPos().equals((Object)signPos)).findFirst();
    }

    public boolean isNodeSignLinked(@Nullable class_2338 nodePos, @Nullable class_2338 signPos) {
        if (nodePos == null && signPos == null) {
            return false;
        }
        if (nodePos != null && signPos != null) {
            return this.getTemporaryNodeLink(nodePos).isPresent() == this.getTemporarySignLink(signPos).isPresent();
        }
        if (nodePos != null) {
            return this.getTemporaryNodeLink(nodePos).isPresent();
        }
        return this.getTemporarySignLink(signPos).isPresent();
    }

    public Optional<Node> getNearestNode(class_2338 origin, double maxDistance, boolean includeTemp) {
        return this.getNearestNode(origin, maxDistance, maxDistance, includeTemp, node -> true, node -> true);
    }

    public Optional<Node> getNearestNode(class_2338 origin, double maxDistance, double maxYDistance, boolean includeTemp) {
        return this.getNearestNode(origin, maxDistance, maxYDistance, includeTemp, node -> true, node -> true);
    }

    public Optional<Node> getNearestNode(class_2338 origin, double maxDistance, boolean includeTemp, Predicate<Node> graphFilter, Predicate<Node> clientFilter) {
        return this.getNearestNode(origin, maxDistance, maxDistance, includeTemp, graphFilter, clientFilter);
    }

    public Optional<Node> getNearestNode(class_2338 origin, double maxDistance, double maxYDistance, boolean includeTemp, Predicate<Node> graphFilter, Predicate<Node> clientFilter) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return Optional.empty();
        }
        return this.getNearestNode(origin, maxDistance, maxYDistance, includeTemp, graphFilter, clientFilter, (class_5321<class_1937>)mc.field_1687.method_27983());
    }

    public Optional<Node> getNearestNode(class_2338 origin, double maxDistance, double maxYDistance, boolean includeTemp, Predicate<Node> graphFilter, Predicate<Node> clientFilter, class_5321<class_1937> dimension) {
        double tempNodeDistance;
        PathGraph graph = this.getGraph(dimension);
        if (graph == null) {
            return Optional.empty();
        }
        Optional<Node> bestPersistent = graph.getNearestNode(origin, maxDistance, graphFilter);
        if (!includeTemp || this.temporaryNodes.isEmpty()) {
            return bestPersistent;
        }
        double maxDistSq = maxDistance * maxDistance;
        Optional<Node> bestTemporary = this.temporaryNodes.stream().map(data -> new Node(data.pos().method_10063(), data.quality(), data.clearance())).filter(clientFilter).filter(node -> ClientPathData.calculateDistance(node.getBlockPos(), origin, false) <= maxDistSq && (double)Math.abs(node.getBlockPos().method_10264() - origin.method_10264()) <= maxYDistance).min(Comparator.comparingDouble(node -> ClientPathData.calculateDistance(node.getBlockPos(), origin, true)));
        if (bestPersistent.isEmpty()) {
            return bestTemporary;
        }
        if (bestTemporary.isEmpty()) {
            return bestPersistent;
        }
        Node persistentNode = bestPersistent.get();
        Node temporaryNode = bestTemporary.get();
        double persistentNodeDistance = ClientPathData.calculateDistance(persistentNode.getBlockPos(), origin);
        return persistentNodeDistance <= (tempNodeDistance = ClientPathData.calculateDistance(temporaryNode.getBlockPos(), origin)) ? bestPersistent : bestTemporary;
    }

    public List<Node> getNearbyNodes(class_2338 center, double radius, boolean includeTemp) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return new ArrayList<Node>();
        }
        return this.getNearbyNodes(center, radius, includeTemp, (class_5321<class_1937>)mc.field_1687.method_27983());
    }

    public List<Node> getNearbyNodes(class_2338 center, double radius, boolean includeTemp, class_5321<class_1937> dimension) {
        ArrayList<Node> result = new ArrayList<Node>();
        PathGraph graph = this.getGraph(dimension);
        if (graph != null) {
            result.addAll(graph.queryNearby(center, radius));
        }
        if (includeTemp) {
            double r2 = radius * radius;
            double cx = (double)center.method_10263() + 0.5;
            double cy = (double)center.method_10264() + 0.5;
            double cz = (double)center.method_10260() + 0.5;
            for (Node.NodeData packed : this.temporaryNodes) {
                double dz;
                double dy;
                double dx = (double)packed.pos().method_10263() + 0.5 - cx;
                if (!(dx * dx + (dy = (double)packed.pos().method_10264() + 0.5 - cy) * dy + (dz = (double)packed.pos().method_10260() + 0.5 - cz) * dz <= r2)) continue;
                result.add(new Node(packed.pos().method_10063(), packed.quality(), packed.clearance()));
            }
        }
        return result;
    }

    public static double calculateDistance(class_2338 a, class_2338 b) {
        return ClientPathData.calculateDistance(a, b, false);
    }

    public static double calculateDistance(class_2338 a, class_2338 b, boolean includeY) {
        double dx = (double)a.method_10263() + 0.5 - ((double)b.method_10263() + 0.5);
        double dy = includeY ? (double)a.method_10264() + 0.5 - ((double)b.method_10264() + 0.5) : 0.0;
        double dz = (double)a.method_10260() + 0.5 - ((double)b.method_10260() + 0.5);
        return dx * dx + dy * dy + dz * dz;
    }
}

