/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.integration.surveyor;

import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.Landmarks;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.integration.surveyor.ViaRomanaLandmark;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;

public class ViaRomanaLandmarkManager {
    public static void initialize() {
        Landmarks.register(ViaRomanaLandmark.TYPE);
        ViaRomana.LOGGER.info("Initialized Via Romana Destination landmark type.");
    }

    public static void addDestinationLandmark(class_1937 level, Node node) {
        if (!CommonConfig.enable_surveyor_landmark) {
            return;
        }
        if (!(level instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)level;
        try {
            WorldSummary worldSummary = WorldSummary.of((class_1937)serverLevel);
            WorldLandmarks landmarks = worldSummary.landmarks();
            class_2338 nodePos = node.getBlockPos();
            assert (landmarks != null);
            if (landmarks.contains(ViaRomanaLandmark.TYPE, nodePos)) {
                landmarks.remove((class_1937)serverLevel, ViaRomanaLandmark.TYPE, nodePos);
            }
            if (node.getLinkType() != Node.LinkType.DESTINATION) {
                return;
            }
            ViaRomanaLandmark landmark = ViaRomanaLandmark.createDestination(serverLevel, node, nodePos);
            landmarks.put((class_1937)serverLevel, (Landmark)landmark);
        }
        catch (Exception e) {
            ViaRomana.LOGGER.warn("Failed to add destination landmark", (Throwable)e);
        }
    }

    public static void removeDestinationLandmark(class_1937 level, Node node) {
        if (!CommonConfig.enable_surveyor_landmark) {
            return;
        }
        if (!(level instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)level;
        try {
            WorldSummary worldSummary = WorldSummary.of((class_1937)serverLevel);
            WorldLandmarks landmarks = worldSummary.landmarks();
            class_2338 nodePos = node.getBlockPos();
            assert (landmarks != null);
            landmarks.remove((class_1937)serverLevel, ViaRomanaLandmark.TYPE, nodePos);
        }
        catch (Exception e) {
            ViaRomana.LOGGER.warn("Failed to remove destination landmark", (Throwable)e);
        }
    }

    public static void updateAllNetworkColors(PathGraph graph, class_3218 level) {
        WorldLandmarks worldLandmarks;
        if (!CommonConfig.enable_surveyor_landmark) {
            return;
        }
        if (!CommonConfig.enable_surveyor_landmark_coloring) {
            return;
        }
        try {
            worldLandmarks = WorldSummary.of((class_1937)level).landmarks();
        }
        catch (Exception e) {
            ViaRomana.LOGGER.warn("Failed to access WorldLandmarks, skipping network color update.", (Throwable)e);
            return;
        }
        HashSet<UUID> processedNetworks = new HashSet<UUID>();
        List<Node> nodes = graph.nodesView();
        for (Node node : nodes) {
            PathGraph.NetworkCache cache = graph.getNetworkCache(node);
            if (processedNetworks.contains(cache.id())) continue;
            class_1767 requiredColor = graph.getNetworkColor(node);
            for (Node destinationNode : cache.destinationNodes()) {
                try {
                    Landmark landmark = worldLandmarks.get(ViaRomanaLandmark.TYPE, destinationNode.getBlockPos());
                    if (landmark == null || landmark.color() == requiredColor) continue;
                    ViaRomanaLandmark updatedLandmark = ViaRomanaLandmark.createDestination(level, destinationNode, destinationNode.getBlockPos());
                    worldLandmarks.put((class_1937)level, (Landmark)updatedLandmark);
                }
                catch (Exception e) {
                    ViaRomana.LOGGER.warn("Failed to update landmark color for node at {}: {}", (Object)destinationNode.getBlockPos(), (Object)e.getMessage());
                }
            }
            processedNetworks.add(cache.id());
        }
    }
}

