/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.map.MapBaker;
import net.rasanovum.viaromana.map.ServerMapCache;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.util.VersionUtils;

public record PreProcessChunksC2S(List<Node.NodeData> tempNodes) {
    public static final class_2960 TYPE = VersionUtils.getLocation("via_romana:pre_process_chunks_c2s");
    public static final Object STREAM_CODEC = null;

    public PreProcessChunksC2S(List<Node.NodeData> tempNodes) {
        this.tempNodes = tempNodes != null ? List.copyOf(tempNodes) : List.of();
    }

    public static void encode(class_2540 buffer, PreProcessChunksC2S packet) {
        buffer.writeInt(packet.tempNodes.size());
        for (Node.NodeData nodeData : packet.tempNodes) {
            buffer.method_10807(nodeData.pos());
            buffer.writeFloat(nodeData.quality());
            buffer.writeFloat(nodeData.clearance());
        }
    }

    public static PreProcessChunksC2S decode(class_2540 buffer) {
        int nodeCount = buffer.readInt();
        ArrayList<Node.NodeData> nodes = new ArrayList<Node.NodeData>(nodeCount);
        for (int i = 0; i < nodeCount; ++i) {
            class_2338 pos = buffer.method_10811();
            float quality = buffer.readFloat();
            float clearance = buffer.readFloat();
            nodes.add(new Node.NodeData(pos, quality, clearance));
        }
        return new PreProcessChunksC2S(nodes);
    }

    public static void handle(PacketContext<PreProcessChunksC2S> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            class_3218 level = ctx.sender().method_51469();
            List<Node.NodeData> tempNodes = ((PreProcessChunksC2S)ctx.message()).tempNodes();
            UUID playerUUID = ctx.sender().method_5667();
            if (tempNodes.isEmpty() || tempNodes.size() < 2) {
                return;
            }
            UUID pseudoNetworkId = ServerMapCache.getPseudoNetworkId(playerUUID);
            ViaRomana.LOGGER.debug("Creating/updating pseudonetwork {} for player {} with {} temp nodes", (Object)pseudoNetworkId, (Object)ctx.sender().method_5477().getString(), (Object)tempNodes.size());
            PathGraph graph = PathGraph.getInstance(level);
            if (graph == null) {
                ViaRomana.LOGGER.warn("PathGraph is null, cannot create pseudonetwork");
                return;
            }
            graph.createOrUpdatePseudoNetwork(pseudoNetworkId, tempNodes);
            ServerMapCache.markAsPseudoNetwork(pseudoNetworkId);
            ExecutorService executor = ServerMapCache.getMapBakingExecutor();
            if (executor != null && !executor.isShutdown()) {
                ((CompletableFuture)MapBaker.bakeAsync(pseudoNetworkId, level, executor).thenAccept(mapInfo -> {
                    if (mapInfo != null) {
                        ViaRomana.LOGGER.debug("Completed async chunk pre-processing for pseudonetwork {}: {}x{} pixels", (Object)pseudoNetworkId, (Object)mapInfo.pixelWidth(), (Object)mapInfo.pixelHeight());
                    }
                })).exceptionally(ex -> {
                    ViaRomana.LOGGER.error("Error during async chunk pre-processing for pseudonetwork {}", (Object)pseudoNetworkId, ex);
                    return null;
                });
            } else {
                ViaRomana.LOGGER.warn("Map baking executor not available, skipping chunk pre-processing");
            }
        }
    }
}

