/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.core.LinkHandler;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.util.VersionUtils;

public record SignLinkRequestC2S(LinkHandler.LinkData linkData, boolean isTempNode) {
    public static final class_2960 TYPE = VersionUtils.getLocation("via_romana:link_sign_request");
    public static final Object STREAM_CODEC = null;

    public static void encode(class_2540 buf, SignLinkRequestC2S packet) {
        buf.method_10807(packet.linkData.nodePos());
        buf.method_10807(packet.linkData.signPos());
        buf.method_10817((Enum)packet.linkData.linkType());
        buf.writeBoolean(packet.linkData.owner() != null);
        if (packet.linkData.owner() != null) {
            buf.method_10797(packet.linkData.owner());
        }
        buf.method_10814(packet.linkData.destinationName());
        buf.method_10817((Enum)packet.linkData.icon());
        buf.writeBoolean(packet.isTempNode);
    }

    public static SignLinkRequestC2S decode(class_2540 buf) {
        class_2338 nodePos = buf.method_10811();
        class_2338 signPos = buf.method_10811();
        Node.LinkType linkType = (Node.LinkType)buf.method_10818(Node.LinkType.class);
        UUID owner = buf.readBoolean() ? buf.method_10790() : null;
        String destinationName = buf.method_19772();
        Node.Icon icon = (Node.Icon)buf.method_10818(Node.Icon.class);
        LinkHandler.LinkData linkData = new LinkHandler.LinkData(signPos, nodePos, linkType, icon, destinationName, owner);
        boolean isTempNode = buf.readBoolean();
        return new SignLinkRequestC2S(linkData, isTempNode);
    }

    public static void handle(PacketContext<SignLinkRequestC2S> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            LinkHandler.LinkData linkData;
            class_3218 level = ctx.sender().method_51469();
            boolean success = LinkHandler.linkSignToNode(level, linkData = ((SignLinkRequestC2S)ctx.message()).linkData());
            if (!success) {
                ViaRomana.LOGGER.warn("Failed to link sign at {} to node at {} for player {}", (Object)linkData.signPos(), (Object)linkData.nodePos(), (Object)ctx.sender().method_5477().getString());
            } else {
                ViaRomana.LOGGER.debug("Successfully linked sign at {} to node at {} for player {}", (Object)linkData.signPos(), (Object)linkData.nodePos(), (Object)ctx.sender().method_5477().getString());
            }
        }
    }
}

