/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.storage.level;

import dev.corgitaco.dataanchor.data.registry.TrackedDataKey;
import dev.corgitaco.dataanchor.data.type.level.ServerLevelTrackedData;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;

public class LevelPixelTrackedData
extends ServerLevelTrackedData {
    private final Map<String, byte[]> pixelMap = new HashMap<String, byte[]>();

    public LevelPixelTrackedData(TrackedDataKey<? extends ServerLevelTrackedData> trackedDataKey, class_3218 level) {
        super(trackedDataKey, level);
    }

    public class_2487 save() {
        if (this.pixelMap.isEmpty()) {
            return null;
        }
        class_2487 tag = new class_2487();
        tag.method_10566("pixel_map", (class_2520)LevelPixelTrackedData.toNBT(this.pixelMap));
        return tag;
    }

    public void load(class_2487 tag) {
        if (tag.method_10545("pixel_map")) {
            this.pixelMap.clear();
            this.pixelMap.putAll(LevelPixelTrackedData.fromNBT(tag.method_10562("pixel_map")));
        }
    }

    public void setPixelBytes(class_1923 pos, byte[] bytes) {
        String key = pos.field_9181 + "_" + pos.field_9180;
        if (bytes != null && bytes.length == 256) {
            this.pixelMap.put(key, (byte[])bytes.clone());
        } else {
            this.pixelMap.remove(key);
        }
        this.markDirty();
    }

    public Optional<byte[]> getPixelBytes(class_1923 pos) {
        String key = pos.field_9181 + "_" + pos.field_9180;
        byte[] bytes = this.pixelMap.get(key);
        return bytes != null && bytes.length == 256 ? Optional.of((byte[])bytes.clone()) : Optional.empty();
    }

    private static class_2487 toNBT(Map<String, byte[]> map) {
        class_2487 tag = new class_2487();
        for (Map.Entry<String, byte[]> entry : map.entrySet()) {
            tag.method_10570(entry.getKey(), entry.getValue());
        }
        return tag;
    }

    private static Map<String, byte[]> fromNBT(class_2487 tag) {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        for (String key : tag.method_10541()) {
            map.put(key, tag.method_10547(key));
        }
        return map;
    }

    public void clearAll() {
        this.pixelMap.clear();
        this.markDirty();
    }
}

