/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.tags;

import com.google.gson.Gson;
import eu.midnightdust.lib.config.MidnightConfig;
import eu.midnightdust.lib.util.PlatformFunctions;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynServerResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.tags.TagGenerator;
import org.apache.logging.log4j.Logger;

public class ServerResourcesGenerator
extends DynServerResourcesGenerator {
    public ServerResourcesGenerator(DynamicDataPack pack) {
        super(pack);
    }

    public Logger getLogger() {
        return ViaRomana.LOGGER;
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        ResourceGenTask task = (manager, sink) -> {
            try {
                try {
                    Field gsonField = MidnightConfig.class.getDeclaredField("gson");
                    gsonField.setAccessible(true);
                    Gson gson = (Gson)gsonField.get(null);
                    Path configPath = PlatformFunctions.getConfigDirectory().resolve("via_romana.json");
                    gson.fromJson((Reader)Files.newBufferedReader(configPath), CommonConfig.class);
                }
                catch (Exception e) {
                    ViaRomana.LOGGER.error("Failed to reload config from file", (Throwable)e);
                }
                TagGenerator.generateAllTags((DynamicDataPack)this.getPack(), manager);
                ViaRomana.LOGGER.info("Successfully regenerated dynamic server resources.");
            }
            catch (Exception e) {
                ViaRomana.LOGGER.error("Failed to generate dynamic server resources.", (Throwable)e);
            }
        };
        executor.accept(task);
    }
}

